/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.erp.service;

import cn.vertxup.erp.domain.tables.daos.EEmployeeDao;
import cn.vertxup.erp.domain.tables.pojos.EEmployee;
import cn.vertxup.erp.service.EmployeeStub;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.ke.refine.Ke;
import io.vertx.tp.optic.Trash;
import io.vertx.tp.optic.business.ExSerial;
import io.vertx.tp.optic.business.ExUser;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Set;
import java.util.function.BiFunction;

public class EmployeeService
implements EmployeeStub {
    @Override
    public Future<JsonObject> createAsync(JsonObject data) {
        EEmployee employee = (EEmployee)Ut.deserialize((JsonObject)data, EEmployee.class);
        if (Ut.isNil((String)employee.getWorkNumber())) {
            return Ke.channelAsync(ExSerial.class, () -> this.insertAsync(employee, data), serial -> serial.serial(data.getString("sigma"), "NUM.EMPLOYEE").compose(workNum -> {
                employee.setWorkNumber((String)workNum);
                return this.insertAsync(employee, data);
            }));
        }
        return this.insertAsync(employee, data);
    }

    private Future<JsonObject> insertAsync(EEmployee employee, JsonObject data) {
        return Ux.Jooq.on(EEmployeeDao.class).insertAsync((Object)employee).compose(Ux::futureJ).compose(inserted -> {
            if (data.containsKey("userId")) {
                String key = data.getString("userId");
                return this.updateRef(key, (JsonObject)inserted);
            }
            return Ux.future((Object)data);
        });
    }

    @Override
    public Future<JsonObject> fetchAsync(String key) {
        return Ux.Jooq.on(EEmployeeDao.class).fetchByIdAsync((Object)key).compose(Ux::futureJ).compose(this::fetchRef);
    }

    @Override
    public Future<JsonArray> fetchAsync(Set<String> keys) {
        return Ux.Jooq.on(EEmployeeDao.class).fetchInAsync("key", Ut.toJArray(keys)).compose(Ux::futureA).compose(this::fetchRef);
    }

    @Override
    public Future<JsonArray> fetchAsync(JsonObject condition) {
        return Ux.Jooq.on(EEmployeeDao.class).fetchAsync(condition).compose(Ux::futureA).compose(this::fetchRef);
    }

    @Override
    public Future<JsonObject> updateAsync(String key, JsonObject data) {
        return this.fetchAsync(key).compose(Ut.ifNil(JsonObject::new, original -> {
            String userId = original.getString("userId");
            String current = data.getString("userId");
            if (Ut.isNil((String)userId) && Ut.isNil((String)current)) {
                return this.updateEmployee(key, data);
            }
            if (Ut.isNil((String)userId) && Ut.notNil((String)current)) {
                return this.updateEmployee(key, data).compose(response -> this.updateRef(current, (JsonObject)response));
            }
            if (Ut.notNil((String)userId) && Ut.isNil((String)current)) {
                return this.updateEmployee(key, data).compose(response -> this.updateRef(userId, new JsonObject()).compose(nil -> Ux.future((Object)response)));
            }
            if (userId.equals(current)) {
                return this.updateEmployee(key, data);
            }
            return this.updateEmployee(key, data).compose(response -> this.updateRef(userId, new JsonObject()).compose(nil -> this.updateRef(current, (JsonObject)response)));
        }));
    }

    private Future<JsonObject> updateEmployee(String key, JsonObject data) {
        JsonObject uniques = new JsonObject();
        uniques.put("key", (Object)key);
        EEmployee employee = (EEmployee)Ut.deserialize((JsonObject)data, EEmployee.class);
        return Ux.Jooq.on(EEmployeeDao.class).upsertAsync(uniques, (Object)employee).compose(Ux::futureJ);
    }

    @Override
    public Future<Boolean> deleteAsync(String key) {
        return this.fetchAsync(key).compose(Ut.ifNil(() -> Boolean.TRUE, item -> Ke.channelAsync(Trash.class, () -> this.deleteAsync(key, (JsonObject)item), tunnel -> tunnel.backupAsync("res.employee", item).compose(backup -> this.deleteAsync(key, (JsonObject)item)))));
    }

    private Future<Boolean> deleteAsync(String key, JsonObject item) {
        String userId = item.getString("userId");
        return this.updateRef(userId, new JsonObject()).compose(nil -> Ux.Jooq.on(EEmployeeDao.class).deleteByIdAsync((Object)key));
    }

    private Future<JsonObject> updateRef(String key, JsonObject data) {
        return this.switchJ(data, (user, filters) -> user.updateRef(key, filters).compose(Ut.ifJNil(response -> Ux.future((Object)data.put("userId", (Object)response.getString("key"))))));
    }

    private Future<JsonObject> fetchRef(JsonObject input) {
        return this.switchJ(input, ExUser::fetchRef).compose(Ut.ifJNil(response -> {
            String userId = response.getString("key");
            if (Ut.notNil((String)userId)) {
                return Ux.future((Object)input.put("userId", (Object)userId));
            }
            return Ux.future((Object)input);
        }));
    }

    private Future<JsonArray> fetchRef(JsonArray input) {
        return this.switchA(input, (user, data) -> {
            Set keys = Ut.mapString((JsonArray)data, (String)"key");
            return user.fetchRef(keys);
        }).compose(employee -> {
            JsonArray merged = Ut.elementZip((JsonArray)input, (JsonArray)employee, (String)"key", (String)"modelKey");
            return Ux.future((Object)merged);
        });
    }

    private Future<JsonObject> switchJ(JsonObject input, BiFunction<ExUser, JsonObject, Future<JsonObject>> executor) {
        return Ke.channel(ExUser.class, JsonObject::new, user -> {
            if (Ut.isNil((JsonObject)input)) {
                return Ux.future((Object)new JsonObject());
            }
            JsonObject filters = new JsonObject();
            filters.put("identifier", (Object)"employee");
            filters.put("sigma", (Object)input.getString("sigma"));
            filters.put("key", (Object)input.getString("key"));
            return (Future)executor.apply((ExUser)user, filters);
        });
    }

    private Future<JsonArray> switchA(JsonArray input, BiFunction<ExUser, JsonArray, Future<JsonArray>> executor) {
        return Ke.channel(ExUser.class, JsonArray::new, user -> (Future)executor.apply((ExUser)user, input));
    }
}

