/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.erp.service;

import cn.vertxup.erp.domain.tables.daos.EEmployeeDao;
import cn.vertxup.erp.domain.tables.pojos.EEmployee;
import cn.vertxup.erp.service.EmployeeStub;
import io.horizon.spi.business.ExUser;
import io.horizon.spi.environment.Indent;
import io.horizon.spi.feature.Trash;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.ke.cv.em.BizInternal;
import io.vertx.up.fn.Fn;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Set;
import java.util.function.BiFunction;

public class EmployeeService
implements EmployeeStub {
    @Override
    public Future<JsonObject> createAsync(JsonObject data) {
        EEmployee employee = (EEmployee)Ut.deserialize((JsonObject)data, EEmployee.class);
        if (Ut.isNil((String)employee.getWorkNumber())) {
            return Ux.channelA(Indent.class, () -> this.insertAsync(employee, data), serial -> serial.indent("NUM.EMPLOYEE", data.getString("sigma")).compose(workNum -> {
                employee.setWorkNumber((String)workNum);
                return this.insertAsync(employee, data);
            }));
        }
        return this.insertAsync(employee, data);
    }

    private Future<JsonObject> insertAsync(EEmployee employee, JsonObject data) {
        return Ux.Jooq.on(EEmployeeDao.class).insertAsync((Object)employee).compose(Ux::futureJ).compose(inserted -> {
            if (data.containsKey("userId")) {
                String key = data.getString("userId");
                return this.updateReference(key, (JsonObject)inserted);
            }
            return Ux.future((Object)data);
        });
    }

    @Override
    public Future<JsonObject> fetchAsync(String key) {
        return Ux.Jooq.on(EEmployeeDao.class).fetchByIdAsync((Object)key).compose(Ux::futureJ).compose(this::fetchRef);
    }

    @Override
    public Future<JsonArray> fetchAsync(Set<String> keys) {
        return Ux.Jooq.on(EEmployeeDao.class).fetchInAsync("key", Ut.toJArray(keys)).compose(Ux::futureA).compose(this::fetchRef);
    }

    @Override
    public Future<JsonArray> fetchAsync(JsonObject condition) {
        return Ux.Jooq.on(EEmployeeDao.class).fetchAsync(condition).compose(Ux::futureA).compose(this::fetchRef);
    }

    @Override
    public Future<JsonObject> updateAsync(String key, JsonObject data) {
        return this.fetchAsync(key).compose(Fn.ofJObject(original -> {
            String userId = original.getString("userId");
            String current = data.getString("userId");
            if (Ut.isNil((String)userId) && Ut.isNil((String)current)) {
                return this.updateEmployee(key, data);
            }
            if (Ut.isNil((String)userId) && Ut.isNotNil((String)current)) {
                return this.updateEmployee(key, data).compose(response -> this.updateReference(current, (JsonObject)response));
            }
            if (Ut.isNotNil((String)userId) && Ut.isNil((String)current)) {
                return this.updateEmployee(key, data).compose(response -> this.updateReference(userId, new JsonObject()).compose(nil -> Ux.future((Object)response)));
            }
            if (userId.equals(current)) {
                return this.updateEmployee(key, data);
            }
            return this.updateEmployee(key, data).compose(response -> this.updateReference(userId, new JsonObject()).compose(nil -> this.updateReference(current, (JsonObject)response)));
        }));
    }

    private Future<JsonObject> updateEmployee(String key, JsonObject data) {
        JsonObject uniques = new JsonObject();
        uniques.put("key", (Object)key);
        EEmployee employee = (EEmployee)Ut.deserialize((JsonObject)data, EEmployee.class);
        return Ux.Jooq.on(EEmployeeDao.class).upsertAsync(uniques, (Object)employee).compose(Ux::futureJ);
    }

    @Override
    public Future<Boolean> deleteAsync(String key) {
        return this.fetchAsync(key).compose(Fn.ifNil(() -> Boolean.TRUE, item -> Ux.channelA(Trash.class, () -> this.deleteAsync(key, (JsonObject)item), tunnel -> tunnel.backupAsync("res.employee", item).compose(backup -> this.deleteAsync(key, (JsonObject)item)))));
    }

    private Future<Boolean> deleteAsync(String key, JsonObject item) {
        String userId = item.getString("userId");
        return this.updateReference(userId, new JsonObject()).compose(nil -> Ux.Jooq.on(EEmployeeDao.class).deleteByIdAsync((Object)key));
    }

    private Future<JsonObject> updateReference(String key, JsonObject data) {
        return this.switchJ(data, (user, filters) -> user.rapport(key, filters).compose(Fn.ofJObject(response -> Ux.future((Object)data.put("userId", (Object)response.getString("key"))))));
    }

    private Future<JsonObject> fetchRef(JsonObject input) {
        return this.switchJ(input, ExUser::rapport).compose(userJ -> {
            String userId;
            if (Ut.isNotNil((JsonObject)userJ) && Ut.isNotNil((String)(userId = Ut.valueString((JsonObject)userJ, (String)"key")))) {
                input.put("userId", (Object)userId);
            }
            return Ux.future((Object)input);
        });
    }

    private Future<JsonArray> fetchRef(JsonArray input) {
        return Ux.channel(ExUser.class, JsonArray::new, user -> {
            Set keys = Ut.valueSetString((JsonArray)input, (String)"key");
            return user.rapport(keys);
        }).compose(employee -> {
            JsonArray merged = Ut.elementJoin((JsonArray)input, (JsonArray)employee, (String)"key", (String)"modelKey");
            return Ux.future((Object)merged);
        });
    }

    private Future<JsonObject> switchJ(JsonObject input, BiFunction<ExUser, JsonObject, Future<JsonObject>> executor) {
        return Ux.channel(ExUser.class, JsonObject::new, user -> {
            if (Ut.isNil((JsonObject)input)) {
                JsonObject filters = new JsonObject();
                filters.put("identifier", (Object)BizInternal.TypeUser.employee.name());
                return (Future)executor.apply((ExUser)user, filters);
            }
            JsonObject filters = new JsonObject();
            filters.put("identifier", (Object)BizInternal.TypeUser.employee.name());
            filters.put("sigma", (Object)input.getString("sigma"));
            filters.put("key", (Object)input.getString("key"));
            return (Future)executor.apply((ExUser)user, filters);
        });
    }
}

