/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.graphic.api;

import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.ke.refine.Ke;
import io.vertx.tp.plugin.neo4j.Neo4jClient;
import io.vertx.up.annotations.Address;
import io.vertx.up.annotations.Plugin;
import io.vertx.up.annotations.Queue;
import io.vertx.up.log.Annal;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;

@Queue
public class GraphActor {
    private static final Annal LOGGER = Annal.get(GraphActor.class);
    @Plugin
    private transient Neo4jClient client;

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u03b3\u03c1\u03b1\u03c6\u03b9\u03ba\u03cc/X-GRAPH/BY/NODE")
    public Future<JsonObject> analyze(String key, String graph, Integer level) {
        String graphName;
        String string = graphName = Ut.isNil((String)graph) ? "__VERTX_ZERO__" : graph;
        if (Ut.isNil((String)key)) {
            return Ux.future((Object)new JsonObject());
        }
        LOGGER.info("[ ZERO ] Graphic analyzing for graph = {0}, key = {1}", new Object[]{graphName, key});
        return this.client.connect(graphName).graphicByKey(key, level).compose(graphic -> {
            JsonArray nodeRef = graphic.getJsonArray("nodes");
            Ut.itJArray((JsonArray)nodeRef).forEach(node -> Ke.mount((JsonObject)node, (String)"data"));
            JsonArray edgeRef = graphic.getJsonArray("edges");
            Ut.itJArray((JsonArray)edgeRef).forEach(node -> Ke.mount((JsonObject)node, (String)"data"));
            return Ux.future((Object)graphic);
        });
    }
}

