/*
 * Decompiled with CFR 0.152.
 */
package cn.vertxup.graphic.api;

import io.horizon.uca.log.Annal;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.plugin.neo4j.Neo4jClient;
import io.vertx.tp.plugin.neo4j.Neo4jInfix;
import io.vertx.up.annotations.Address;
import io.vertx.up.annotations.Queue;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;

@Queue
public class GraphActor {
    private static final Annal LOGGER = Annal.get(GraphActor.class);

    @Address(value="\u1f08\u03c4\u03bb\u03b1\u03bd\u03c4\u1f76\u03c2 \u03bd\u1fc6\u03c3\u03bf\u03c2://\u03b3\u03c1\u03b1\u03c6\u03b9\u03ba\u03cc/X-GRAPH/BY/NODE")
    public Future<JsonObject> analyze(String key, String graph, Integer level) {
        String graphName;
        String string = graphName = Ut.isNil((String)graph) ? "__VERTX_ZERO__" : graph;
        if (Ut.isNil((String)key)) {
            return Ux.future((Object)new JsonObject());
        }
        Neo4jClient client = Neo4jInfix.getClient();
        LOGGER.info("[ ZERO ] Graphic analyzing for graph = {0}, key = {1}", new Object[]{graphName, key});
        if (client.connected()) {
            return client.connect(graphName).graphicByKey(key, level).compose(graphic -> {
                JsonArray nodeRef = graphic.getJsonArray("nodes");
                Ut.valueToJArray((JsonArray)nodeRef, (String[])new String[]{"data"});
                JsonArray edgeRef = graphic.getJsonArray("edges");
                Ut.valueToJArray((JsonArray)edgeRef, (String[])new String[]{"data"});
                return Ux.future((Object)graphic);
            });
        }
        return Ux.future((Object)new JsonObject().put("nodes", (Object)new JsonArray()).put("edges", (Object)new JsonArray()));
    }
}

