/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.secure;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authentication.AuthenticationProvider;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.ext.auth.authentication.TokenCredentials;
import io.vertx.ext.auth.authorization.AuthorizationProvider;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.AuthenticationHandler;
import io.vertx.ext.web.handler.AuthorizationHandler;
import io.vertx.ext.web.handler.impl.AuthenticationHandlerImpl;
import io.vertx.ext.web.handler.impl.HTTPAuthorizationHandler;
import io.vertx.tp.error._401UnauthorizedException;
import io.vertx.up.atom.secure.Aegis;
import io.vertx.up.atom.secure.AegisItem;
import io.vertx.up.eon.em.AuthWall;
import io.vertx.up.log.Annal;
import io.vertx.up.secure.LeeBuiltIn;
import io.vertx.up.secure.authenticate.AuthenticateBuiltInProvider;
import io.vertx.up.secure.authenticate.ChainHandler;
import io.vertx.up.secure.authorization.AuthorizationBuiltInHandler;
import io.vertx.up.secure.authorization.AuthorizationBuiltInProvider;
import io.vertx.up.secure.authorization.AuthorizationExtensionHandler;
import io.vertx.up.util.Ut;
import java.util.Objects;

public abstract class AbstractLee
implements LeeBuiltIn {
    public AuthorizationHandler authorization(Vertx vertx, Aegis config) {
        Class handlerCls = config.getHandler();
        if (Objects.isNull(handlerCls)) {
            AuthorizationBuiltInHandler handler = AuthorizationBuiltInHandler.create(config);
            AuthorizationProvider provider = AuthorizationBuiltInProvider.provider(config);
            handler.addAuthorizationProvider(provider);
            AegisItem item = config.item();
            Class providerCls = item.getProviderAuthenticate();
            if (Objects.nonNull(providerCls)) {
                AuthWall wall = config.getType();
                AuthorizationProvider defined = (AuthorizationProvider)Ut.invokeStatic((Class)providerCls, (String)"provider", (Object[])new Object[]{config});
                if (Objects.nonNull(defined)) {
                    handler.addAuthorizationProvider(defined);
                }
            }
            return handler;
        }
        return ((AuthorizationExtensionHandler)Ut.instance((Class)handlerCls, (Object[])new Object[]{vertx})).configure(config);
    }

    protected AuthenticationHandler wrapHandler(AuthenticationHandler standard, Aegis aegis) {
        ChainHandler handler = ChainHandler.all();
        handler.add(standard);
        AuthenticateBuiltInProvider provider = AuthenticateBuiltInProvider.provider(aegis);
        handler.add((AuthenticationHandler)new AuthenticationHandlerImpl(provider){

            public void authenticate(RoutingContext context, Handler<AsyncResult<User>> handler) {
                User user = context.user();
                if (Objects.nonNull(user)) {
                    this.authProvider.authenticate(user.principal(), handler);
                } else {
                    _401UnauthorizedException error = new _401UnauthorizedException(((Object)((Object)this)).getClass());
                    handler.handle((Object)Future.failedFuture((Throwable)((Object)error)));
                }
            }
        });
        return handler;
    }

    protected AuthenticationHandler buildHandler(AuthenticationProvider standard, Aegis aegis, HTTPAuthorizationHandler.Type type) {
        String realm = (String)this.option(aegis, "realm");
        return new HTTPAuthorizationHandler<AuthenticationProvider>(standard, type, realm){

            public void authenticate(RoutingContext context, Handler<AsyncResult<User>> handler) {
                this.parseAuthorization(context, parseAuthorization -> {
                    if (parseAuthorization.failed()) {
                        handler.handle((Object)Future.failedFuture((Throwable)parseAuthorization.cause()));
                        return;
                    }
                    String token = (String)parseAuthorization.result();
                    this.authProvider.authenticate((Credentials)new TokenCredentials(token), handler);
                });
            }
        };
    }

    protected <T> T option(Aegis aegis, String key) {
        AegisItem item = aegis.item();
        return (T)item.options().getValue(key, null);
    }

    protected Annal logger() {
        return Annal.get(this.getClass());
    }
}

