/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.secure;

import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.impl.jose.JWT;
import io.vertx.ext.auth.jwt.JWTAuth;
import io.vertx.ext.auth.jwt.JWTAuthOptions;
import io.vertx.ext.web.handler.AuthenticationHandler;
import io.vertx.ext.web.handler.JWTAuthHandler;
import io.vertx.up.atom.secure.Aegis;
import io.vertx.up.atom.secure.AegisItem;
import io.vertx.up.fn.Fn;
import io.vertx.up.secure.AbstractLee;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

class LeeJwt
extends AbstractLee {
    private static final ConcurrentMap<String, JWTAuth> POOL_PROVIDER = new ConcurrentHashMap<String, JWTAuth>();

    LeeJwt() {
    }

    public AuthenticationHandler authenticate(Vertx vertx, Aegis config) {
        JWTAuth provider = this.provider(vertx, config.item());
        String realm = (String)this.option(config, "realm");
        JWTAuthHandler standard = Ut.isNil((String)realm) ? JWTAuthHandler.create((JWTAuth)provider) : JWTAuthHandler.create((JWTAuth)provider, (String)realm);
        return this.wrapHandler((AuthenticationHandler)standard, config);
    }

    private JWTAuth provider(Vertx vertx, AegisItem item) {
        JWTAuthOptions options = new JWTAuthOptions(item.options());
        String key = item.wall().name() + options.hashCode();
        return (JWTAuth)Fn.poolThread(POOL_PROVIDER, () -> JWTAuth.create((Vertx)vertx, (JWTAuthOptions)options), (String)key);
    }

    public String encode(JsonObject data, AegisItem config) {
        JWTAuth provider = this.provider(Ux.nativeVertx(), config);
        return provider.generateToken(data);
    }

    public JsonObject decode(String token, AegisItem config) {
        JWTAuth provider = this.provider(Ux.nativeVertx(), config);
        JWT jwt = (JWT)Ut.field((Object)provider, (String)"jwt");
        return Objects.isNull(jwt) ? new JsonObject() : jwt.decode(token);
    }
}

