/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.secure;

import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.oauth2.OAuth2Auth;
import io.vertx.ext.auth.oauth2.OAuth2Options;
import io.vertx.ext.web.handler.AuthenticationHandler;
import io.vertx.ext.web.handler.OAuth2AuthHandler;
import io.vertx.up.atom.secure.Aegis;
import io.vertx.up.atom.secure.AegisItem;
import io.vertx.up.fn.Fn;
import io.vertx.up.secure.AbstractLee;
import io.vertx.up.util.Ut;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

class LeeOAuth2
extends AbstractLee {
    private static final ConcurrentMap<String, OAuth2Auth> POOL_PROVIDER = new ConcurrentHashMap<String, OAuth2Auth>();

    LeeOAuth2() {
    }

    public AuthenticationHandler authenticate(Vertx vertx, Aegis config) {
        OAuth2Auth provider = this.provider(vertx, config.item());
        String callback = (String)this.option(config, "callback");
        OAuth2AuthHandler standard = Ut.isNil((String)callback) ? OAuth2AuthHandler.create((Vertx)vertx, (OAuth2Auth)provider) : OAuth2AuthHandler.create((Vertx)vertx, (OAuth2Auth)provider, (String)callback);
        return this.wrapHandler((AuthenticationHandler)standard, config);
    }

    private OAuth2Auth provider(Vertx vertx, AegisItem item) {
        OAuth2Options options = new OAuth2Options(item.options());
        String key = item.wall().name() + options.hashCode();
        return (OAuth2Auth)Fn.poolThread(POOL_PROVIDER, () -> OAuth2Auth.create((Vertx)vertx, (OAuth2Options)options), (String)key);
    }

    public String encode(JsonObject data, AegisItem config) {
        return null;
    }

    public JsonObject decode(String token, AegisItem config) {
        return null;
    }
}

