/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.secure.authenticate;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authentication.AuthenticationProvider;
import io.vertx.tp.error._401UnauthorizedException;
import io.vertx.up.atom.secure.Aegis;
import io.vertx.up.atom.secure.Against;
import io.vertx.up.fn.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.secure.authenticate.AuthenticateCache;
import io.vertx.up.util.Ut;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.function.Function;

public class AuthenticateBuiltInProvider
implements AuthenticationProvider {
    private static final Annal LOGGER = Annal.get(AuthenticateBuiltInProvider.class);
    private final transient Aegis aegis;
    private transient Function<JsonObject, Future<User>> userFn;

    private AuthenticateBuiltInProvider(Aegis aegis) {
        this.aegis = aegis;
        Method method = aegis.getAuthorizer().getUser();
        if (Objects.nonNull(method)) {
            this.userFn = json -> (Future)Fn.getJvm(() -> method.invoke(aegis.getProxy(), json), (Object[])new Object[0]);
        }
    }

    public static AuthenticateBuiltInProvider provider(Aegis aegis) {
        return new AuthenticateBuiltInProvider(aegis);
    }

    private Future<User> buildUser(JsonObject credentials) {
        if (Objects.isNull(this.userFn)) {
            return Future.succeededFuture((Object)User.create((JsonObject)credentials, (JsonObject)new JsonObject()));
        }
        return this.userFn.apply(credentials);
    }

    public void authenticate(JsonObject credentials, Handler<AsyncResult<User>> handler) {
        AuthenticateCache.userAuthorized(credentials, () -> {
            Against against = this.aegis.getAuthorizer();
            Method method = against.getAuthenticate();
            if (Objects.isNull(method)) {
                handler.handle((Object)Future.failedFuture((Throwable)((Object)new _401UnauthorizedException(this.getClass()))));
            } else {
                Object proxy = this.aegis.getProxy();
                Future checkedFuture = Ut.invokeAsync((Object)proxy, (Method)method, (Object[])new Object[]{credentials});
                checkedFuture.onComplete(res -> {
                    if (res.succeeded()) {
                        Boolean checked = (Boolean)res.result();
                        if (Objects.isNull(checked) || !checked.booleanValue()) {
                            handler.handle((Object)Future.failedFuture((Throwable)((Object)new _401UnauthorizedException(this.getClass()))));
                        } else {
                            LOGGER.info("[ Auth ]\u001b[0;32m 401 Authenticated successfully!\u001b[m", new Object[0]);
                            AuthenticateCache.userAuthorize(credentials, () -> handler.handle(this.buildUser(credentials)));
                        }
                    } else {
                        Throwable ex = res.cause();
                        if (Objects.isNull(ex)) {
                            handler.handle((Object)Future.failedFuture((Throwable)((Object)new _401UnauthorizedException(this.getClass()))));
                        } else {
                            handler.handle((Object)Future.failedFuture((Throwable)ex));
                        }
                    }
                });
            }
        }, () -> handler.handle(this.buildUser(credentials)));
    }
}

