/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.secure.authenticate;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authentication.AuthenticationProvider;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.AuthenticationHandler;
import io.vertx.ext.web.handler.HttpException;
import io.vertx.ext.web.handler.impl.AuthenticationHandlerImpl;
import io.vertx.ext.web.handler.impl.AuthenticationHandlerInternal;
import io.vertx.up.secure.authenticate.ChainHandler;
import java.util.ArrayList;
import java.util.List;

public class ChainHandlerImpl
extends AuthenticationHandlerImpl<AuthenticationProvider>
implements ChainHandler {
    private final List<AuthenticationHandlerInternal> handlers = new ArrayList<AuthenticationHandlerInternal>();
    private final boolean all;
    private int willRedirect = -1;

    public ChainHandlerImpl(boolean all) {
        super(null);
        this.all = all;
    }

    public boolean performsRedirect() {
        return this.willRedirect != -1;
    }

    @Override
    public synchronized ChainHandler add(AuthenticationHandler other) {
        if (this.performsRedirect()) {
            throw new IllegalStateException("Cannot add a handler after a handler known to perform a HTTP redirect: " + this.handlers.get(this.willRedirect));
        }
        AuthenticationHandlerInternal otherInternal = (AuthenticationHandlerInternal)other;
        if (otherInternal.performsRedirect()) {
            this.willRedirect = this.handlers.size();
        }
        this.handlers.add(otherInternal);
        return this;
    }

    public void authenticate(RoutingContext context, Handler<AsyncResult<User>> handler) {
        if (this.handlers.size() == 0) {
            handler.handle((Object)Future.failedFuture((String)"No providers in the auth chain."));
        } else {
            this.iterate(0, context, null, null, handler);
        }
    }

    private void iterate(int idx, RoutingContext ctx, User result, Throwable exception, Handler<AsyncResult<User>> handler) {
        if (idx >= this.handlers.size()) {
            if (this.all) {
                if (exception == null) {
                    handler.handle((Object)Future.succeededFuture((Object)result));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)exception));
                }
            } else {
                handler.handle((Object)Future.failedFuture((Throwable)exception));
            }
            return;
        }
        AuthenticationHandlerInternal authHandler = this.handlers.get(idx);
        authHandler.authenticate(ctx, res -> {
            if (res.failed()) {
                if (!this.all && res.cause() instanceof HttpException) {
                    HttpException ex = (HttpException)res.cause();
                    switch (ex.getStatusCode()) {
                        case 302: 
                        case 400: 
                        case 401: 
                        case 403: {
                            this.iterate(idx + 1, ctx, null, (Throwable)ex, handler);
                            return;
                        }
                    }
                }
                handler.handle((Object)Future.failedFuture((Throwable)res.cause()));
                return;
            }
            if (this.all) {
                ctx.setUser((User)res.result());
                this.iterate(idx + 1, ctx, (User)res.result(), null, handler);
            } else {
                handler.handle((Object)Future.succeededFuture((Object)((User)res.result())));
            }
        });
    }

    public String authenticateHeader(RoutingContext ctx) {
        for (AuthenticationHandlerInternal authHandler : this.handlers) {
            String header = authHandler.authenticateHeader(ctx);
            if (header == null) continue;
            return header;
        }
        return null;
    }
}

