/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.secure.authorization;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.auth.authorization.AuthorizationProvider;
import io.vertx.up.atom.secure.Aegis;
import io.vertx.up.fn.Fn;
import io.vertx.up.secure.profile.PermissionAuthorization;
import java.lang.reflect.Method;
import java.util.Set;

public class AuthorizationBuiltInProvider
implements AuthorizationProvider {
    private final transient Aegis aegis;

    private AuthorizationBuiltInProvider(Aegis aegis) {
        this.aegis = aegis;
    }

    public static AuthorizationProvider provider(Aegis aegis) {
        return new AuthorizationBuiltInProvider(aegis);
    }

    public String getId() {
        return this.aegis.getType().key();
    }

    public void getAuthorizations(User user, Handler<AsyncResult<Void>> handler) {
        Method method = this.aegis.getAuthorizer().getAuthorization();
        Fn.safeJvm(() -> {
            Future future = (Future)method.invoke(this.aegis.getProxy(), user);
            future.onComplete(res -> {
                if (res.succeeded()) {
                    Set permissionSet = (Set)res.result();
                    PermissionAuthorization authorization = PermissionAuthorization.create(permissionSet);
                    user.authorizations().add(this.getId(), (Authorization)authorization);
                    handler.handle((Object)Future.succeededFuture());
                } else {
                    Throwable ex = res.cause();
                    handler.handle((Object)Future.failedFuture((Throwable)ex));
                }
            });
        });
    }
}

