/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.secure.authorization;

import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.web.RoutingContext;
import io.vertx.up.fn.Actuator;
import io.vertx.up.log.Annal;
import io.vertx.up.uca.cache.Rapid;
import java.util.Objects;

class AuthorizationCache {
    private static final Annal LOGGER = Annal.get(AuthorizationCache.class);

    AuthorizationCache() {
    }

    private static String requestKey(RoutingContext context) {
        HttpServerRequest request = context.request();
        return request.method() + " " + request.path();
    }

    static void userAuthorized(RoutingContext context, Actuator actuator) {
        User user = context.user();
        Rapid rapid = Rapid.user((User)user);
        rapid.read((Object)"ZERO-CACHE-403").onComplete(res -> {
            if (res.succeeded()) {
                String requestKey;
                JsonObject authorized = (JsonObject)res.result();
                if (Objects.isNull(authorized)) {
                    authorized = new JsonObject();
                }
                if (authorized.getBoolean(requestKey = AuthorizationCache.requestKey(context), Boolean.FALSE).booleanValue()) {
                    String habitus = user.principal().getString("habitus");
                    LOGGER.info("[ Auth ]\u001b[0;32m 403 Authorized Cached successfully \u001b[m for ( {1}, {0} )", new Object[]{habitus, requestKey});
                    context.next();
                } else {
                    actuator.execute();
                }
            }
        });
    }

    static void userAuthorize(RoutingContext context, Actuator actuator) {
        User user = context.user();
        Rapid rapid = Rapid.user((User)user);
        rapid.read((Object)"ZERO-CACHE-403").onComplete(res -> {
            if (res.succeeded()) {
                String requestKey = AuthorizationCache.requestKey(context);
                JsonObject authorized = (JsonObject)res.result();
                if (Objects.isNull(authorized)) {
                    authorized = new JsonObject();
                }
                authorized.put(requestKey, (Object)Boolean.TRUE);
                rapid.write((Object)"ZERO-CACHE-403", (Object)authorized).onComplete(next -> actuator.execute());
            }
        });
    }
}

