/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.secure.authorization;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.web.RoutingContext;
import io.vertx.up.atom.secure.Aegis;
import io.vertx.up.atom.secure.Vis;
import io.vertx.up.eon.ID;
import io.vertx.up.runtime.ZeroAnno;
import io.vertx.up.secure.authorization.AuthorizationResourceImpl;
import java.util.Objects;

public interface AuthorizationResource {
    public static JsonObject parameters(RoutingContext context) {
        User user = context.user();
        JsonObject normalized = Objects.isNull(user) ? new JsonObject() : user.principal().copy();
        HttpServerRequest request = context.request();
        JsonObject metadata = new JsonObject();
        metadata.put("uri", (Object)ZeroAnno.recoveryUri((String)request.path(), (HttpMethod)request.method()));
        metadata.put("requestUri", (Object)request.path());
        metadata.put("method", (Object)request.method().name());
        String literal = request.getParam("view");
        Vis view = Vis.create((String)literal);
        metadata.put("view", (Object)view);
        normalized.put("metadata", (Object)metadata);
        MultiMap inputHeaders = request.headers();
        JsonObject headers = new JsonObject();
        inputHeaders.forEach(entry -> {
            if (ID.Header.PARAM_MAP.containsKey(entry.getKey())) {
                headers.put((String)entry.getKey(), entry.getValue());
            }
        });
        normalized.put("headers", (Object)headers);
        return normalized;
    }

    public static AuthorizationResource buildIn(Aegis aegis) {
        return new AuthorizationResourceImpl(aegis);
    }

    public void requestResource(RoutingContext var1, Handler<AsyncResult<Authorization>> var2);
}

