/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.secure.profile;

import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.auth.authorization.AuthorizationContext;
import io.vertx.up.secure.profile.PermissionAuthorization;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class PermissionAuthorizationImpl
implements PermissionAuthorization {
    private final Set<String> permissions = new HashSet<String>();

    PermissionAuthorizationImpl(Set<String> permissions) {
        this.permissions.addAll((Collection<String>)Objects.requireNonNull(permissions));
    }

    @Override
    public Set<String> permissions() {
        return this.permissions;
    }

    public boolean match(AuthorizationContext context) {
        Objects.requireNonNull(context);
        User user = context.user();
        if (user != null) {
            PermissionAuthorization resolved = PermissionAuthorization.create(this.permissions);
            for (String providerId : user.authorizations().getProviderIds()) {
                for (Authorization authorization : user.authorizations().get(providerId)) {
                    if (!authorization.verify((Authorization)resolved)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean verify(Authorization otherAuthorization) {
        Objects.requireNonNull(otherAuthorization);
        if (otherAuthorization instanceof PermissionAuthorization) {
            PermissionAuthorization permission = (PermissionAuthorization)otherAuthorization;
            return this.permissions.containsAll(permission.permissions());
        }
        return false;
    }
}

