/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.secure;

import io.horizon.eon.em.secure.AuthWall;
import io.horizon.uca.cache.Cc;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.authentication.AuthenticationProvider;
import io.vertx.ext.web.handler.AuthenticationHandler;
import io.vertx.ext.web.handler.AuthorizationHandler;
import io.vertx.up.atom.secure.Aegis;
import io.vertx.up.atom.secure.AegisItem;
import io.vertx.up.secure.Lee;
import io.vertx.up.secure.LeeBasic;
import io.vertx.up.secure.LeeBuiltIn;
import io.vertx.up.secure.LeeDigest;
import io.vertx.up.secure.LeeJwt;
import io.vertx.up.secure.LeeOAuth2;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;

public class BridgeLee
implements LeeBuiltIn {
    private static final Cc<String, Lee> CC_LEE = Cc.openThread();
    private static final ConcurrentMap<AuthWall, Supplier<Lee>> LEE_SUPPLIER = new ConcurrentHashMap<AuthWall, Supplier<Lee>>(){
        {
            this.put(AuthWall.BASIC, LeeBasic::new);
            this.put(AuthWall.DIGEST, LeeDigest::new);
            this.put(AuthWall.JWT, LeeJwt::new);
            this.put(AuthWall.OAUTH2, LeeOAuth2::new);
        }
    };

    public AuthenticationHandler authenticate(Vertx vertx, Aegis config) {
        Lee reference = this.component(config.getType());
        return reference.authenticate(vertx, config);
    }

    public AuthorizationHandler authorization(Vertx vertx, Aegis config) {
        Lee reference = this.component(config.getType());
        return reference.authorization(vertx, config);
    }

    public AuthenticationProvider provider(Vertx vertx, Aegis config) {
        Lee reference = this.component(config.getType());
        return reference.provider(vertx, config);
    }

    public String encode(JsonObject data, AegisItem config) {
        Lee reference = this.component(config.wall());
        return reference.encode(data, config);
    }

    public JsonObject decode(String token, AegisItem config) {
        Lee reference = this.component(config.wall());
        return reference.decode(token, config);
    }

    private Lee component(AuthWall wall) {
        Supplier supplier = LEE_SUPPLIER.getOrDefault(wall, null);
        Objects.requireNonNull(supplier);
        return (Lee)CC_LEE.pick(supplier, (Object)wall.key());
    }
}

