/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.secure;

import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.authentication.AuthenticationProvider;
import io.vertx.ext.web.handler.AuthenticationHandler;
import io.vertx.ext.web.handler.BasicAuthHandler;
import io.vertx.up.atom.secure.Aegis;
import io.vertx.up.atom.secure.AegisItem;
import io.vertx.up.secure.AbstractLee;
import io.vertx.up.secure.authenticate.AdapterProvider;
import io.vertx.up.util.Ut;

class LeeBasic
extends AbstractLee {
    LeeBasic() {
    }

    public AuthenticationHandler authenticate(Vertx vertx, Aegis config) {
        AuthenticationProvider provider = this.providerInternal(vertx, config);
        String realm = (String)this.option(config, "realm");
        if (Ut.isNil((String)realm)) {
            return BasicAuthHandler.create((AuthenticationProvider)provider);
        }
        return BasicAuthHandler.create((AuthenticationProvider)provider, (String)realm);
    }

    public AuthenticationProvider provider(Vertx vertx, Aegis config) {
        AuthenticationProvider standard = this.providerInternal(vertx, config);
        AdapterProvider extension = AdapterProvider.extension(standard);
        return extension.provider(config);
    }

    public AuthenticationProvider providerInternal(Vertx vertx, Aegis config) {
        AdapterProvider adapter = AdapterProvider.common();
        return adapter.provider(config);
    }

    public String encode(JsonObject data, AegisItem config) {
        String username = data.getString("username", null);
        if (Ut.isNil((String)username)) {
            return null;
        }
        String password = data.getString("password", "");
        return Ut.encryptBase64((String)username, (String)password);
    }

    public JsonObject decode(String token, AegisItem config) {
        String decoded = Ut.decryptBase64((String)token);
        int colonIdx = decoded.indexOf(":");
        JsonObject data = new JsonObject();
        if (colonIdx != -1) {
            data.put("username", (Object)decoded.substring(0, colonIdx));
            data.put("password", (Object)decoded.substring(colonIdx + 1));
        } else {
            data.put("username", (Object)decoded);
        }
        return data;
    }
}

