/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.secure;

import io.horizon.uca.cache.Cc;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.authentication.AuthenticationProvider;
import io.vertx.ext.auth.impl.jose.JWT;
import io.vertx.ext.auth.jwt.JWTAuth;
import io.vertx.ext.auth.jwt.JWTAuthOptions;
import io.vertx.ext.web.handler.AuthenticationHandler;
import io.vertx.ext.web.handler.JWTAuthHandler;
import io.vertx.up.atom.secure.Aegis;
import io.vertx.up.atom.secure.AegisItem;
import io.vertx.up.secure.AbstractLee;
import io.vertx.up.secure.authenticate.AdapterProvider;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.Objects;

class LeeJwt
extends AbstractLee {
    private static final Cc<String, JWTAuth> CC_PROVIDER = Cc.openThread();

    LeeJwt() {
    }

    public AuthenticationHandler authenticate(Vertx vertx, Aegis config) {
        JWTAuth provider = this.providerInternal(vertx, config);
        String realm = (String)this.option(config, "realm");
        JWTAuthHandler standard = Ut.isNil((String)realm) ? JWTAuthHandler.create((JWTAuth)provider) : JWTAuthHandler.create((JWTAuth)provider, (String)realm);
        return this.wrapHandler((AuthenticationHandler)standard, config);
    }

    public AuthenticationProvider provider(Vertx vertx, Aegis config) {
        JWTAuth standard = this.providerInternal(vertx, config);
        AdapterProvider extension = AdapterProvider.extension((AuthenticationProvider)standard);
        return extension.provider(config);
    }

    public JWTAuth providerInternal(Vertx vertx, Aegis config) {
        AegisItem item = config.item();
        return this.provider(vertx, item);
    }

    private JWTAuth provider(Vertx vertx, AegisItem item) {
        JWTAuthOptions options = new JWTAuthOptions(item.options());
        String key = item.wall().name() + options.hashCode();
        return (JWTAuth)CC_PROVIDER.pick(() -> JWTAuth.create((Vertx)vertx, (JWTAuthOptions)options), (Object)key);
    }

    public String encode(JsonObject data, AegisItem config) {
        JWTAuth provider = this.provider(Ux.nativeVertx(), config);
        return provider.generateToken(data);
    }

    public JsonObject decode(String token, AegisItem config) {
        JWTAuth provider = this.provider(Ux.nativeVertx(), config);
        JWT jwt = (JWT)Ut.field((Object)provider, (String)"jwt");
        return Objects.isNull(jwt) ? new JsonObject() : jwt.decode(token);
    }
}

