/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.secure;

import io.horizon.uca.cache.Cc;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.authentication.AuthenticationProvider;
import io.vertx.ext.auth.oauth2.OAuth2Auth;
import io.vertx.ext.auth.oauth2.OAuth2Options;
import io.vertx.ext.web.handler.AuthenticationHandler;
import io.vertx.ext.web.handler.OAuth2AuthHandler;
import io.vertx.up.atom.secure.Aegis;
import io.vertx.up.atom.secure.AegisItem;
import io.vertx.up.secure.AbstractLee;
import io.vertx.up.secure.authenticate.AdapterProvider;
import io.vertx.up.util.Ut;

class LeeOAuth2
extends AbstractLee {
    private static final Cc<String, OAuth2Auth> CC_PROVIDER = Cc.openThread();

    LeeOAuth2() {
    }

    public AuthenticationHandler authenticate(Vertx vertx, Aegis config) {
        OAuth2Auth provider = this.providerInternal(vertx, config);
        String callback = (String)this.option(config, "callback");
        OAuth2AuthHandler standard = Ut.isNil((String)callback) ? OAuth2AuthHandler.create((Vertx)vertx, (OAuth2Auth)provider) : OAuth2AuthHandler.create((Vertx)vertx, (OAuth2Auth)provider, (String)callback);
        return this.wrapHandler((AuthenticationHandler)standard, config);
    }

    public AuthenticationProvider provider(Vertx vertx, Aegis config) {
        OAuth2Auth standard = this.providerInternal(vertx, config);
        AdapterProvider extension = AdapterProvider.extension((AuthenticationProvider)standard);
        return extension.provider(config);
    }

    public OAuth2Auth providerInternal(Vertx vertx, Aegis config) {
        AegisItem item = config.item();
        OAuth2Options options = new OAuth2Options(item.options());
        String key = item.wall().name() + options.hashCode();
        return (OAuth2Auth)CC_PROVIDER.pick(() -> OAuth2Auth.create((Vertx)vertx, (OAuth2Options)options), (Object)key);
    }

    public String encode(JsonObject data, AegisItem config) {
        return null;
    }

    public JsonObject decode(String token, AegisItem config) {
        return null;
    }
}

