/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.secure.authenticate;

import io.horizon.eon.em.secure.AuthWall;
import io.horizon.uca.log.Annal;
import io.vertx.ext.auth.authentication.AuthenticationProvider;
import io.vertx.up.atom.secure.Aegis;
import io.vertx.up.atom.secure.AegisItem;
import io.vertx.up.secure.authenticate.AdapterProvider;
import io.vertx.up.util.Ut;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AbstractAdapter
implements AdapterProvider {
    private static final AtomicBoolean LOG_401 = new AtomicBoolean(Boolean.TRUE);

    protected AuthenticationProvider provider401Internal(Aegis aegis) {
        AegisItem item = aegis.item();
        Class providerCls = item.getProviderAuthenticate();
        if (Objects.isNull(providerCls)) {
            return null;
        }
        AuthWall wall = aegis.getType();
        AuthenticationProvider provider = (AuthenticationProvider)Ut.invokeStatic((Class)providerCls, (String)"provider", (Object[])new Object[]{aegis});
        if (Objects.isNull(provider) && LOG_401.getAndSet(Boolean.FALSE)) {
            this.logger().error("[ Auth ] 401 provider created failure! type = {0}", new Object[]{wall});
        }
        return provider;
    }

    private Annal logger() {
        return Annal.get(this.getClass());
    }
}

