/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.secure.authenticate;

import io.horizon.exception.web._401UnauthorizedException;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authentication.AuthenticationProvider;
import io.vertx.up.atom.secure.Aegis;
import io.vertx.up.secure.authenticate.AbstractAdapter;
import io.vertx.up.secure.authenticate.AuthenticateBuiltInProvider;

class AdapterExtension
extends AbstractAdapter {
    private final AuthenticationProvider standard;

    AdapterExtension(AuthenticationProvider standard) {
        this.standard = standard;
    }

    @Override
    public AuthenticationProvider provider(Aegis aegis) {
        final AuthenticateBuiltInProvider provider = AuthenticateBuiltInProvider.provider(aegis);
        return new AuthenticationProvider(){

            public void authenticate(JsonObject jsonObject, Handler<AsyncResult<User>> handler) {
                AdapterExtension.this.standard.authenticate(jsonObject, res -> {
                    if (res.succeeded()) {
                        provider.authenticate(jsonObject, handler);
                    } else {
                        _401UnauthorizedException error = new _401UnauthorizedException(this.getClass());
                        handler.handle((Object)Future.failedFuture((Throwable)error));
                    }
                });
            }
        };
    }
}

