/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.secure.authenticate;

import io.horizon.exception.web._401UnauthorizedException;
import io.horizon.uca.log.Annal;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authentication.AuthenticationProvider;
import io.vertx.up.atom.secure.Aegis;
import io.vertx.up.fn.Fn;
import io.vertx.up.secure.authenticate.AuthenticateGateway;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.function.Function;

public class AuthenticateBuiltInProvider
implements AuthenticationProvider {
    private static final Annal LOGGER = Annal.get(AuthenticateBuiltInProvider.class);
    private final transient Aegis aegis;
    private transient Function<JsonObject, Future<User>> userFn;

    private AuthenticateBuiltInProvider(Aegis aegis) {
        this.aegis = aegis;
        Method method = aegis.getAuthorizer().getUser();
        if (Objects.nonNull(method)) {
            this.userFn = json -> (Future)Fn.failOr(() -> method.invoke(aegis.getProxy(), json));
        }
    }

    public static AuthenticateBuiltInProvider provider(Aegis aegis) {
        return new AuthenticateBuiltInProvider(aegis);
    }

    public void authenticate(JsonObject credentials, Handler<AsyncResult<User>> handler) {
        AuthenticateGateway.userCached(credentials, () -> this.authenticateInternal(credentials, handler), () -> handler.handle(this.buildUser(credentials)));
    }

    private void authenticateInternal(JsonObject credentials, Handler<AsyncResult<User>> handler) {
        AuthenticateGateway.userVerified(credentials, this.aegis, (Handler<AsyncResult<Boolean>>)((Handler)res -> {
            Boolean checked = (Boolean)res.result();
            if (checked.booleanValue()) {
                LOGGER.info("[ Auth ]\u001b[0;32m 401 Authenticated successfully!\u001b[m", new Object[0]);
                AuthenticateGateway.userCached(credentials, () -> handler.handle(this.buildUser(credentials)));
            } else {
                handler.handle((Object)Future.failedFuture((Throwable)new _401UnauthorizedException(this.getClass())));
            }
        }));
    }

    private Future<User> buildUser(JsonObject credentials) {
        if (Objects.isNull(this.userFn)) {
            return Future.succeededFuture((Object)User.create((JsonObject)credentials, (JsonObject)new JsonObject()));
        }
        return this.userFn.apply(credentials);
    }
}

