/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.secure.authenticate;

import io.horizon.exception.web._401UnauthorizedException;
import io.horizon.fn.Actuator;
import io.horizon.uca.log.Annal;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.up.atom.secure.Aegis;
import io.vertx.up.atom.secure.Against;
import io.vertx.up.uca.cache.Rapid;
import io.vertx.up.uca.log.DevEnv;
import io.vertx.up.util.Ut;
import java.lang.reflect.Method;
import java.util.Objects;

public class AuthenticateGateway {
    private static final Annal LOGGER = Annal.get(AuthenticateGateway.class);

    public static void userCached(JsonObject credentials, Actuator actuator, Actuator fnCache) {
        String habitus = credentials.getString("habitus");
        Rapid rapid = Rapid.t((String)habitus);
        rapid.read((Object)"ZERO-CACHE-401").onComplete(res -> {
            if (res.succeeded()) {
                JsonObject cached = (JsonObject)res.result();
                if (Objects.isNull(cached)) {
                    actuator.execute();
                } else {
                    if (DevEnv.devAuthorized()) {
                        LOGGER.info("[ Auth ]\u001b[0;32m 401 Authenticated Cached successfully!\u001b[m", new Object[0]);
                    }
                    fnCache.execute();
                }
            }
        });
    }

    public static void userCached(JsonObject credentials, Actuator actuator) {
        String habitus = credentials.getString("habitus");
        Rapid rapid = Rapid.t((String)habitus);
        rapid.write((Object)"ZERO-CACHE-401", (Object)credentials).onComplete(next -> actuator.execute());
    }

    public static void userVerified(JsonObject credentials, Aegis aegis, Handler<AsyncResult<Boolean>> handler) {
        Against against = aegis.getAuthorizer();
        Method method = against.getAuthenticate();
        if (Objects.isNull(method)) {
            handler.handle((Object)Future.failedFuture((Throwable)new _401UnauthorizedException(AuthenticateGateway.class)));
        } else {
            Object proxy = aegis.getProxy();
            Future checkedFuture = Ut.invokeAsync((Object)proxy, (Method)method, (Object[])new Object[]{credentials});
            checkedFuture.onComplete(res -> {
                if (res.succeeded()) {
                    Boolean checked = (Boolean)res.result();
                    checked = !Objects.isNull(checked) && checked != false;
                    handler.handle((Object)Future.succeededFuture((Object)checked));
                } else {
                    Throwable ex = res.cause();
                    if (Objects.isNull(ex)) {
                        handler.handle((Object)Future.failedFuture((Throwable)new _401UnauthorizedException(AuthenticateGateway.class)));
                    } else {
                        handler.handle((Object)Future.failedFuture((Throwable)ex));
                    }
                }
            });
        }
    }
}

