/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.secure.authorization;

import io.horizon.exception.WebException;
import io.horizon.exception.web._403ForbiddenException;
import io.horizon.uca.log.Annal;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.auth.authorization.AuthorizationContext;
import io.vertx.ext.auth.authorization.AuthorizationProvider;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.AuthorizationHandler;
import io.vertx.up.atom.secure.Aegis;
import io.vertx.up.secure.authorization.AuthorizationCache;
import io.vertx.up.secure.authorization.AuthorizationResource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.BiConsumer;

public class AuthorizationBuiltInHandler
implements AuthorizationHandler {
    private static final Annal LOGGER = Annal.get(AuthorizationBuiltInHandler.class);
    private final transient Collection<AuthorizationProvider> providers;
    private final transient AuthorizationResource resource;
    private BiConsumer<RoutingContext, AuthorizationContext> consumer;

    private AuthorizationBuiltInHandler(AuthorizationResource resource) {
        this.resource = resource;
        this.providers = new ArrayList<AuthorizationProvider>();
    }

    public static AuthorizationBuiltInHandler create(Aegis aegis) {
        return new AuthorizationBuiltInHandler(AuthorizationResource.buildIn(aegis));
    }

    public static AuthorizationBuiltInHandler create(AuthorizationResource resource) {
        return new AuthorizationBuiltInHandler(resource);
    }

    public AuthorizationHandler variableConsumer(BiConsumer<RoutingContext, AuthorizationContext> handler) {
        this.consumer = handler;
        return this;
    }

    public void handle(RoutingContext event) {
        _403ForbiddenException error = new _403ForbiddenException(this.getClass());
        if (Objects.isNull(event.user())) {
            event.fail((Throwable)error);
        } else {
            AuthorizationCache.userAuthorized(event, () -> this.lambda$handle$1(event, (WebException)error));
        }
    }

    private void checkOrFetchAuthorizations(RoutingContext routingContext, Authorization resource, AuthorizationContext authorizationContext, Iterator<AuthorizationProvider> providers) {
        if (resource.match(authorizationContext)) {
            User user = authorizationContext.user();
            String session = user.principal().getString("session");
            LOGGER.info("[ Auth ]\u001b[0;32m 403 Authorized successfully \u001b[m for ( {0} ) user: principal = {1}, attribute = {2}", new Object[]{session, user.principal(), user.attributes()});
            AuthorizationCache.userAuthorize(routingContext, () -> {
                routingContext.request().resume();
                routingContext.next();
            });
            return;
        }
        if (!providers.hasNext()) {
            routingContext.request().resume();
            routingContext.fail((Throwable)new _403ForbiddenException(this.getClass()));
            return;
        }
        while (providers.hasNext()) {
            AuthorizationProvider provider = providers.next();
            if (routingContext.user().authorizations().getProviderIds().contains(provider.getId())) continue;
            User user = routingContext.user();
            provider.getAuthorizations(user, result -> {
                if (result.failed()) {
                    LOGGER.warn("[ Auth ] Error occurs when getting authorization - providerId: {0}", new Object[]{provider.getId()});
                    LOGGER.fatal(result.cause());
                }
                this.checkOrFetchAuthorizations(routingContext, resource, authorizationContext, providers);
            });
        }
    }

    private AuthorizationContext getAuthorizationContext(RoutingContext event) {
        AuthorizationContext result = AuthorizationContext.create((User)event.user());
        if (this.consumer != null) {
            this.consumer.accept(event, result);
        }
        return result;
    }

    public AuthorizationHandler addAuthorizationProvider(AuthorizationProvider authorizationProvider) {
        Objects.requireNonNull(authorizationProvider);
        this.providers.add(authorizationProvider);
        return this;
    }

    private /* synthetic */ void lambda$handle$1(RoutingContext event, WebException error) {
        event.request().pause();
        try {
            AuthorizationContext authorizationContext = this.getAuthorizationContext(event);
            this.resource.requestResource(event, (Handler<AsyncResult<Authorization>>)((Handler)res -> {
                if (res.succeeded()) {
                    this.checkOrFetchAuthorizations(event, (Authorization)res.result(), authorizationContext, this.providers.iterator());
                } else {
                    Throwable ex = res.cause();
                    event.request().resume();
                    if (Objects.nonNull(ex)) {
                        event.fail(ex);
                    } else {
                        event.fail((Throwable)error);
                    }
                }
            }));
        }
        catch (RuntimeException ex) {
            event.request().resume();
            event.fail((Throwable)ex);
        }
    }
}

