/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.secure.authorization;

import io.horizon.eon.em.secure.AuthWord;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.authorization.AndAuthorization;
import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.auth.authorization.OrAuthorization;
import io.vertx.ext.web.RoutingContext;
import io.vertx.up.annotations.AuthorizedResource;
import io.vertx.up.atom.secure.Aegis;
import io.vertx.up.fn.Fn;
import io.vertx.up.secure.authorization.AuthorizationResource;
import io.vertx.up.secure.profile.PermissionAuthorization;
import io.vertx.up.util.Ut;
import java.lang.reflect.Method;
import java.util.Set;

public class AuthorizationResourceImpl
implements AuthorizationResource {
    private final transient Aegis aegis;

    AuthorizationResourceImpl(Aegis aegis) {
        this.aegis = aegis;
    }

    @Override
    public void requestResource(RoutingContext context, Handler<AsyncResult<Authorization>> handler) {
        JsonObject params = AuthorizationResource.parameters(context);
        Method method = this.aegis.getAuthorizer().getResource();
        Fn.jvmAt(() -> {
            Future future = (Future)method.invoke(this.aegis.getProxy(), params);
            future.onComplete(res -> {
                if (res.succeeded()) {
                    Authorization required = this.getResource(res.result(), method);
                    handler.handle((Object)Future.succeededFuture((Object)required));
                } else {
                    Throwable ex = res.cause();
                    handler.handle((Object)Future.failedFuture((Throwable)ex));
                }
            });
        });
    }

    private Authorization getResource(Object item, Method method) {
        PermissionAuthorization required;
        AuthorizedResource annotation = method.getAnnotation(AuthorizedResource.class);
        AuthWord word = (AuthWord)Ut.invoke((Object)annotation, (String)"value", (Object[])new Object[0]);
        if (item instanceof Set) {
            Set set = (Set)item;
            if (AuthWord.AND == word) {
                AndAuthorization and = AndAuthorization.create();
                set.forEach(each -> and.addAuthorization((Authorization)PermissionAuthorization.create(each)));
                required = and;
            } else {
                OrAuthorization and = OrAuthorization.create();
                set.forEach(each -> and.addAuthorization((Authorization)PermissionAuthorization.create(each)));
                required = and;
            }
        } else {
            required = PermissionAuthorization.create((String)item);
        }
        return required;
    }
}

