/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.elasticsearch;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.plugin.elasticsearch.ElasticSearchHelper;
import io.vertx.up.log.Annal;
import io.vertx.up.util.Ut;
import java.io.IOException;
import java.util.function.Supplier;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;

public abstract class AbstractEsClient {
    protected final transient ElasticSearchHelper helper = ElasticSearchHelper.helper(this.getClass());
    private final transient JsonObject options = new JsonObject();

    AbstractEsClient(JsonObject options) {
        if (Ut.notNil((JsonObject)options)) {
            this.options.mergeIn(options.copy());
        }
    }

    protected RestHighLevelClient client() {
        return this.helper.getClient(this.options);
    }

    protected String getString(String field) {
        return this.options.getString(field);
    }

    protected Annal logger() {
        return Annal.get(this.getClass());
    }

    protected Boolean doBatch(JsonArray documents, String idField, Supplier<BulkRequest> executor) {
        boolean result;
        if (Ut.isNil((JsonArray)documents)) {
            return true;
        }
        RestHighLevelClient client = this.client();
        try {
            BulkRequest request = executor.get();
            BulkResponse bulkResponse = client.bulk(request, RequestOptions.DEFAULT);
            if (bulkResponse.hasFailures()) {
                this.logger().warn("Failure found: {0}", new Object[]{bulkResponse.buildFailureMessage()});
                result = false;
            } else {
                this.logger().info("Documents have been indexed ( size = {0} ) successfully!", new Object[]{documents.size()});
                result = true;
            }
        }
        catch (IOException ioe) {
            this.logger().jvm((Throwable)ioe);
            result = false;
        }
        this.helper.closeClient(client);
        return result;
    }
}

