/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.elasticsearch;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.plugin.elasticsearch.AbstractEsClient;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.ConcurrentMap;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.CreateIndexResponse;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.client.indices.GetIndexResponse;

public class ElasticIndexer
extends AbstractEsClient {
    private ElasticIndexer(JsonObject options) {
        super(options);
    }

    static ElasticIndexer create(JsonObject options) {
        return new ElasticIndexer(options);
    }

    JsonObject getIndex(String index) {
        JsonObject result = new JsonObject();
        RestHighLevelClient client = this.client();
        try {
            GetIndexRequest request = new GetIndexRequest(new String[]{index}).includeDefaults(true).indicesOptions(IndicesOptions.lenientExpandOpen());
            GetIndexResponse response = client.indices().get(request, RequestOptions.DEFAULT);
            this.toResultGet(response, result);
        }
        catch (IOException ioe) {
            this.logger().error("failed to get index information", new Object[0]);
            this.logger().error(ioe.getMessage(), new Object[0]);
        }
        this.helper.closeClient(client);
        return result;
    }

    JsonObject updateIndex(String index, int numberOfShards, int numberOfReplicas) {
        JsonObject result = new JsonObject();
        RestHighLevelClient client = this.client();
        try {
            UpdateSettingsRequest request = new UpdateSettingsRequest(new String[]{index}).settings(this.helper.settingsBuilder(numberOfShards, numberOfReplicas));
            AcknowledgedResponse response = client.indices().putSettings(request, RequestOptions.DEFAULT);
            result.put("isAcknowledged", Boolean.valueOf(response.isAcknowledged()));
        }
        catch (IOException ioe) {
            this.logger().jvm((Throwable)ioe);
        }
        this.helper.closeClient(client);
        return result;
    }

    JsonObject createIndex(String index, int numberOfShards, int numberOfReplicas, ConcurrentMap<String, Class<?>> mappings) {
        JsonObject result = new JsonObject();
        RestHighLevelClient client = this.client();
        try {
            CreateIndexRequest request = new CreateIndexRequest(index).alias(new Alias(this.getString("index"))).settings(this.helper.settingsBuilder(numberOfShards, numberOfReplicas)).mapping(this.helper.mappingsBuilder(mappings));
            CreateIndexResponse response = client.indices().create(request, RequestOptions.DEFAULT);
            result.put("isAcknowledged", Boolean.valueOf(response.isAcknowledged()));
        }
        catch (IOException ioe) {
            this.logger().jvm((Throwable)ioe);
        }
        this.helper.closeClient(client);
        return result;
    }

    JsonObject deleteIndex(String index) {
        JsonObject result = new JsonObject();
        RestHighLevelClient client = this.client();
        try {
            DeleteIndexRequest request = new DeleteIndexRequest(index);
            AcknowledgedResponse response = client.indices().delete(request, RequestOptions.DEFAULT);
            result.put("isAcknowledged", Boolean.valueOf(response.isAcknowledged()));
        }
        catch (IOException | ElasticsearchException ioe) {
            this.logger().jvm(ioe);
        }
        this.helper.closeClient(client);
        return result;
    }

    private void toResultGet(GetIndexResponse response, JsonObject result) {
        result.put("index", Arrays.asList(response.getIndices()));
        JsonArray aliases = new JsonArray();
        response.getAliases().forEach((key, val) -> val.forEach(item -> aliases.add(item.getAlias())));
        result.put("aliases", aliases);
        JsonObject settings = new JsonObject();
        response.getSettings().forEach((key, val) -> {
            JsonObject data = new JsonObject();
            val.keySet().forEach(name -> data.put(name, val.get(name)));
            settings.put(key, data);
        });
        result.put("settings", settings);
        JsonObject mappings = new JsonObject();
        response.getMappings().forEach((key, val) -> mappings.put(key, (Object)val.getSourceAsMap()));
        result.put("mappings", mappings);
    }
}

