/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.elasticsearch;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.plugin.elasticsearch.AbstractEsClient;
import io.vertx.tp.plugin.elasticsearch.EsAmbit;
import io.vertx.up.util.Ut;
import java.io.IOException;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;

public class EsAmbitAdd
extends AbstractEsClient
implements EsAmbit {
    private final transient String index;

    public EsAmbitAdd(String index, JsonObject options) {
        super(options);
        this.index = index;
    }

    @Override
    public JsonObject process(String documentId, JsonObject body) {
        JsonObject result = new JsonObject();
        RestHighLevelClient client = this.client();
        try {
            IndexRequest request = new IndexRequest(this.index).id(documentId).source(body.getMap());
            IndexResponse response = client.index(request, RequestOptions.DEFAULT);
            result.put("index", response.getIndex()).put("id", response.getId()).put("result", Boolean.valueOf(response.getResult() == DocWriteResponse.Result.CREATED));
        }
        catch (IOException ioe) {
            this.logger().jvm((Throwable)ioe);
        }
        this.helper.closeClient(client);
        return result;
    }

    @Override
    public Boolean process(JsonArray documents, String idField) {
        return this.doBatch(documents, idField, () -> {
            BulkRequest request = new BulkRequest();
            Ut.itJArray((JsonArray)documents).forEach(json -> {
                String documentId = json.getString(idField);
                if (Ut.notNil((String)documentId)) {
                    IndexRequest indexRequest = new IndexRequest(this.index).id(documentId).source(json.getMap());
                    request.add(indexRequest);
                }
            });
            return request;
        });
    }
}

