/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.elasticsearch;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.plugin.elasticsearch.AbstractEsClient;
import io.vertx.tp.plugin.elasticsearch.EsAmbit;
import io.vertx.up.util.Ut;
import java.io.IOException;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;

public class EsAmbitUpdate
extends AbstractEsClient
implements EsAmbit {
    private final transient String index;

    public EsAmbitUpdate(String index, JsonObject options) {
        super(options);
        this.index = index;
    }

    @Override
    public JsonObject process(String documentId, JsonObject body) {
        JsonObject result = new JsonObject();
        RestHighLevelClient client = this.client();
        try {
            UpdateRequest request = ((UpdateRequest)new UpdateRequest().index(this.index)).id(documentId).doc(this.toDocument(body));
            UpdateResponse response = client.update(request, RequestOptions.DEFAULT);
            result.put("index", (Object)response.getIndex()).put("id", (Object)response.getId()).put("result", (Object)(response.getResult() == DocWriteResponse.Result.UPDATED ? 1 : 0));
        }
        catch (IOException ioe) {
            this.logger().jvm((Throwable)ioe);
        }
        this.helper.closeClient(client);
        return result;
    }

    @Override
    public Boolean process(JsonArray documents, String idField) {
        return this.doBatch(documents, idField, () -> {
            BulkRequest request = new BulkRequest();
            Ut.itJArray((JsonArray)documents).forEach(json -> {
                String documentId = json.getString(idField);
                if (Ut.notNil((String)documentId)) {
                    UpdateRequest indexRequest = ((UpdateRequest)new UpdateRequest().index(this.index)).id(documentId).doc(this.toDocument((JsonObject)json));
                    request.add(indexRequest);
                }
            });
            return request;
        });
    }
}

