/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.elasticsearch;

import io.horizon.uca.log.Annal;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.error._404IndexNameMissingExceptionn;
import io.vertx.tp.error._404SearchTextMissingExceptionn;
import io.vertx.tp.plugin.elasticsearch.ElasticSearchHelper;
import io.vertx.up.fn.Fn;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.ConcurrentMap;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.builder.SearchSourceBuilder;

class ElasticQr {
    private static final Annal LOGGER = Annal.get(ElasticQr.class);
    private final transient ElasticSearchHelper helper = ElasticSearchHelper.helper(this.getClass());
    private final transient JsonObject options = new JsonObject();

    ElasticQr() {
    }

    ElasticQr bind(JsonObject options) {
        this.options.mergeIn(options.copy(), true);
        return this;
    }

    JsonObject search(JsonObject params, ConcurrentMap<String, String> precision) {
        this.paramRequired(params);
        JsonObject result = new JsonObject();
        RestHighLevelClient client = this.helper.getClient(this.options);
        try {
            String index = params.getString("index");
            String searchText = params.getString("searchText");
            int from = params.containsKey("from") ? params.getInteger("from") : 0;
            int size = params.containsKey("size") ? params.getInteger("size") : 10;
            SearchSourceBuilder condition = this.helper.searchSourceBuilder(searchText, precision, from, size);
            SearchRequest request = new SearchRequest(new String[]{index}).source(condition);
            SearchResponse response = client.search(request, RequestOptions.DEFAULT);
            result.put("index", (Object)this.options.getString("index")).put("status", (Object)response.status().name()).put("took", (Object)response.getTook().seconds()).put("total", (Object)response.getHits().getTotalHits().value);
            this.getHitsAndAggregationsFromResponse(response, result);
        }
        catch (IOException ioe) {
            LOGGER.fatal((Throwable)ioe);
        }
        this.helper.closeClient(client);
        return result;
    }

    private void getHitsAndAggregationsFromResponse(SearchResponse response, JsonObject result) {
        JsonArray hits = new JsonArray();
        Arrays.stream(response.getHits().getHits()).forEach(hit -> {
            JsonObject data = new JsonObject().put("index", (Object)hit.getIndex()).put("id", (Object)hit.getId()).put("score", (Object)Float.valueOf(hit.getScore())).put("source", (Object)hit.getSourceAsMap());
            hits.add((Object)data);
        });
        result.put("hits", (Object)hits);
        JsonArray aggregations = new JsonArray();
        Aggregations aggres = response.getAggregations();
        Terms customAggregation = (Terms)aggres.get("aggregations");
        customAggregation.getBuckets().forEach(item -> aggregations.add((Object)new JsonObject().put("key", (Object)item.getKeyAsString()).put("count", (Object)item.getDocCount())));
        result.put("aggregations", (Object)aggregations);
    }

    private void paramRequired(JsonObject params) {
        Fn.outWeb((!params.containsKey("index") ? 1 : 0) != 0, _404IndexNameMissingExceptionn.class, (Object[])new Object[]{this.getClass()});
        Fn.outWeb((!params.containsKey("searchText") ? 1 : 0) != 0, _404SearchTextMissingExceptionn.class, (Object[])new Object[]{this.getClass()});
    }
}

