/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.elasticsearch;

import io.horizon.eon.em.typed.ChangeFlag;
import io.horizon.uca.log.Annal;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.plugin.elasticsearch.ElasticIndexer;
import io.vertx.tp.plugin.elasticsearch.ElasticQr;
import io.vertx.tp.plugin.elasticsearch.ElasticSearchClient;
import io.vertx.tp.plugin.elasticsearch.ElasticSearchHelper;
import io.vertx.tp.plugin.elasticsearch.EsAmbit;
import io.vertx.up.fn.Fn;
import io.vertx.up.util.Ut;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;

public class ElasticSearchClientImpl
implements ElasticSearchClient {
    private static final Annal LOGGER = Annal.get(ElasticSearchClientImpl.class);
    private final transient Vertx vertx;
    private final transient JsonObject options = new JsonObject();
    @Deprecated
    private final transient ElasticSearchHelper helper = ElasticSearchHelper.helper(this.getClass());
    private final transient ElasticQr qr = new ElasticQr();
    private final transient ElasticIndexer indexer;

    ElasticSearchClientImpl(Vertx vertx, JsonObject options) {
        this.vertx = vertx;
        if (Ut.isNotNil((JsonObject)options)) {
            LOGGER.info("[ ZERO ] Elastic Search initialized: {0}", new Object[]{options.encode()});
            this.options.mergeIn(options);
            this.qr.bind(options);
        }
        this.indexer = ElasticIndexer.create(this.options);
    }

    private RestHighLevelClient getClient() {
        return this.helper.getClient(this.options);
    }

    @Override
    public boolean connected() {
        return (Boolean)Fn.failOr((Object)Boolean.FALSE, () -> this.getClient().ping(RequestOptions.DEFAULT));
    }

    @Override
    public JsonObject getIndex(String index) {
        return this.indexer.getIndex(index);
    }

    @Override
    public JsonObject deleteIndex(String index) {
        return this.indexer.deleteIndex(index);
    }

    @Override
    public JsonObject createIndex(String index, ConcurrentMap<String, Class<?>> mappings) {
        return this.indexer.createIndex(index, 5, 1, mappings);
    }

    @Override
    public JsonObject createIndex(String index, int numberOfShards, int numberOfReplicas, ConcurrentMap<String, Class<?>> mappings) {
        return this.indexer.createIndex(index, numberOfShards, numberOfReplicas, mappings);
    }

    @Override
    public JsonObject updateIndex(String index) {
        return this.indexer.updateIndex(index, 5, 1);
    }

    @Override
    public JsonObject updateIndex(String index, int numberOfShards, int numberOfReplicas) {
        return this.indexer.updateIndex(index, numberOfShards, numberOfReplicas);
    }

    @Override
    public JsonObject createDocument(String index, String documentId, JsonObject source) {
        EsAmbit ambit = EsAmbit.create(ChangeFlag.ADD, index, this.options);
        return ambit.process(documentId, source);
    }

    @Override
    public Boolean createDocuments(String index, JsonArray documents) {
        return this.createDocuments(index, documents, "key");
    }

    @Override
    public Boolean createDocuments(String index, JsonArray documents, String keyField) {
        EsAmbit ambit = EsAmbit.create(ChangeFlag.ADD, index, this.options);
        return ambit.process(documents, keyField);
    }

    @Override
    public JsonObject getDocument(String index, String documentId) {
        JsonObject result = new JsonObject();
        RestHighLevelClient client = this.getClient();
        try {
            GetRequest request = ((GetRequest)new GetRequest().index(index)).id(documentId);
            GetResponse response = client.get(request, RequestOptions.DEFAULT);
            result.put("index", (Object)response.getIndex()).put("id", (Object)response.getId()).put("result", (Object)response.isExists());
            if (response.isExists()) {
                result.put("data", (Object)response.getSource());
            }
        }
        catch (IOException ioe) {
            LOGGER.fatal((Throwable)ioe);
        }
        this.helper.closeClient(client);
        return result;
    }

    @Override
    public JsonObject updateDocument(String index, String documentId, JsonObject source) {
        EsAmbit ambit = EsAmbit.create(ChangeFlag.UPDATE, index, this.options);
        return ambit.process(documentId, source);
    }

    @Override
    public Boolean updateDocuments(String index, JsonArray documents) {
        EsAmbit ambit = EsAmbit.create(ChangeFlag.UPDATE, index, this.options);
        return ambit.process(documents, "key");
    }

    @Override
    public Boolean updateDocuments(String index, JsonArray documents, String keyField) {
        EsAmbit ambit = EsAmbit.create(ChangeFlag.UPDATE, index, this.options);
        return ambit.process(documents, keyField);
    }

    @Override
    public JsonObject deleteDocument(String index, String documentId) {
        EsAmbit ambit = EsAmbit.create(ChangeFlag.DELETE, index, this.options);
        return ambit.process(documentId, null);
    }

    @Override
    public Boolean deleteDocuments(String index, Set<String> ids) {
        EsAmbit ambit = EsAmbit.create(ChangeFlag.DELETE, index, this.options);
        return ambit.process(Ut.toJArray(ids), null);
    }

    @Override
    public JsonObject search(JsonObject params) {
        return this.qr.search(params, null);
    }

    @Override
    public JsonObject search(JsonObject params, ConcurrentMap<String, String> precisionMap) {
        return this.qr.search(params, precisionMap);
    }
}

