/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.elasticsearch;

import io.horizon.uca.cache.Cc;
import io.horizon.uca.log.Annal;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.error._404ConfigurationMissingExceptionn;
import io.vertx.up.fn.Fn;
import io.vertx.up.util.Ut;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MatchPhraseQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;

public class ElasticSearchHelper {
    private static final Annal LOGGER = Annal.get(ElasticSearchHelper.class);
    private static final Cc<String, ElasticSearchHelper> CC_HELPER = Cc.open();
    private final transient Class<?> target;

    private ElasticSearchHelper(Class<?> target) {
        this.target = target;
    }

    static ElasticSearchHelper helper(Class<?> target) {
        return (ElasticSearchHelper)CC_HELPER.pick(() -> new ElasticSearchHelper(target), (Object)target.getName());
    }

    RestHighLevelClient getClient(JsonObject options) {
        Fn.outWeb((boolean)Ut.isNil((JsonObject)options), _404ConfigurationMissingExceptionn.class, (Object[])new Object[]{this.getClass()});
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(options.getString("username"), options.getString("password")));
        return new RestHighLevelClient(RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(options.getString("hostname"), options.getInteger("port").intValue(), options.getString("scheme"))}).setHttpClientConfigCallback(new RestClientBuilder.HttpClientConfigCallback(){
            final /* synthetic */ CredentialsProvider val$credentialsProvider;
            {
                this.val$credentialsProvider = credentialsProvider;
            }

            public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder httpAsyncClientBuilder) {
                httpAsyncClientBuilder.disableAuthCaching();
                return httpAsyncClientBuilder.setDefaultCredentialsProvider(this.val$credentialsProvider).setMaxConnTotal(100).setMaxConnPerRoute(100);
            }
        }).setRequestConfigCallback(new RestClientBuilder.RequestConfigCallback(){

            public RequestConfig.Builder customizeRequestConfig(RequestConfig.Builder builder) {
                return builder.setConnectionRequestTimeout(60000).setConnectTimeout(60000).setSocketTimeout(60000);
            }
        }));
    }

    void closeClient(RestHighLevelClient client) {
        try {
            client.close();
        }
        catch (IOException ioe) {
            LOGGER.error("error occurred when close elasticsearch connection", new Object[]{ioe.getMessage()});
        }
    }

    Settings settingsBuilder(int numberOfShards, int numberOfReplicas) {
        return Settings.builder().put("index.number_of_shards", numberOfShards > 0 ? numberOfShards : 3).put("index.number_of_replicas", numberOfReplicas > 0 ? numberOfReplicas : 2).build();
    }

    Map<String, Object> mappingsBuilder(ConcurrentMap<String, Class<?>> mappings) {
        HashMap properties = new HashMap();
        if (mappings.containsKey("key")) {
            HashMap<String, Object> keyProp = new HashMap<String, Object>();
            keyProp.put("type", "keyword");
            keyProp.put("index", true);
            properties.put("key", keyProp);
            mappings.remove("key");
        }
        mappings.forEach((key, val) -> {
            HashMap<String, String> props = new HashMap<String, String>();
            if (val == JsonObject.class || val == JsonArray.class) {
                props.put("type", "text");
                props.put("index", "false");
            } else if (val == String.class) {
                props.put("type", "text");
                props.put("index", "true");
                props.put("analyzer", "ik_max_word");
            } else if (val == LocalTime.class || val == LocalDateTime.class || val == LocalDate.class || val == Instant.class) {
                props.put("type", "date");
                props.put("index", "true");
                props.put("format", "yyyy-MM-dd||yyyy-MM-dd HH:mm:ss||yyyy-MM-dd HH:mm:ss.SSS||yyyy-MM-dd'T'HH:mm:ss'Z'||yyyy-MM-dd'T'HH:mm:ss.SSS'Z'||epoch_millis");
            } else if (val == Integer.class) {
                props.put("type", "integer");
                props.put("index", "true");
            } else if (val == Long.class) {
                props.put("type", "long");
                props.put("index", "true");
            } else if (val == Double.class || val == Float.class || val == BigDecimal.class) {
                props.put("type", "double");
                props.put("index", "true");
            } else if (val == Boolean.class) {
                props.put("type", "boolean");
                props.put("index", "true");
            } else {
                props.put("type", "text");
                props.put("index", "true");
                props.put("analyzer", "ik_max_word");
            }
            properties.put((String)key, props);
        });
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("properties", properties);
        return result;
    }

    SearchSourceBuilder searchSourceBuilder(String searchText, ConcurrentMap<String, String> precision, int from, int size) {
        QueryStringQueryBuilder textCond = QueryBuilders.queryStringQuery((String)searchText);
        SearchSourceBuilder builder = new SearchSourceBuilder();
        if (Objects.isNull(precision) || precision.isEmpty()) {
            builder.query((QueryBuilder)textCond);
            LOGGER.debug("[ ZERO ] Final query condition: {0}", new Object[]{textCond.toString()});
        } else {
            BoolQueryBuilder condition = QueryBuilders.boolQuery();
            precision.forEach((field, value) -> {
                MatchPhraseQueryBuilder fieldCond = QueryBuilders.matchPhraseQuery((String)field, (Object)value);
                condition.must((QueryBuilder)fieldCond);
            });
            BoolQueryBuilder finalCond = QueryBuilders.boolQuery();
            finalCond.must((QueryBuilder)condition).must((QueryBuilder)textCond);
            builder.query((QueryBuilder)finalCond);
            LOGGER.debug("[ ZERO ] Final query condition with precision: {0}", new Object[]{finalCond.toString()});
        }
        return builder.aggregation((AggregationBuilder)AggregationBuilders.terms((String)"aggregations").field("_index")).highlighter((HighlightBuilder)((HighlightBuilder)((HighlightBuilder)new HighlightBuilder().field("*").preTags(new String[]{"<strong>"})).postTags(new String[]{"</strong>"})).highlighterType("unified")).from(Math.max(0, from)).size(Math.max(10, size)).timeout(new TimeValue(10L, TimeUnit.SECONDS));
    }
}

