/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.elasticsearch;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.plugin.elasticsearch.AbstractEsClient;
import io.vertx.tp.plugin.elasticsearch.EsAmbit;
import io.vertx.up.util.Ut;
import java.io.IOException;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;

public class EsAmbitDelete
extends AbstractEsClient
implements EsAmbit {
    private final transient String index;

    public EsAmbitDelete(String index, JsonObject options) {
        super(options);
        this.index = index;
    }

    @Override
    public JsonObject process(String documentId, JsonObject body) {
        JsonObject result = new JsonObject();
        RestHighLevelClient client = this.client();
        try {
            DeleteRequest request = ((DeleteRequest)new DeleteRequest().index(this.index)).id(documentId);
            DeleteResponse response = client.delete(request, RequestOptions.DEFAULT);
            result.put("index", (Object)response.getIndex()).put("id", (Object)response.getId()).put("result", (Object)(response.getResult() == DocWriteResponse.Result.DELETED ? 1 : 0));
        }
        catch (IOException ioe) {
            this.logger().fatal((Throwable)ioe);
        }
        this.helper.closeClient(client);
        return result;
    }

    @Override
    public Boolean process(JsonArray data, String idField) {
        return this.doBatch(data, idField, () -> {
            BulkRequest request = new BulkRequest();
            Ut.itJString((JsonArray)data).forEach(documentId -> request.add(((DeleteRequest)new DeleteRequest().index(this.index)).id(documentId)));
            return request;
        });
    }
}

