/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.excel;

import com.fasterxml.jackson.core.type.TypeReference;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.error._404ExcelFileNullException;
import io.vertx.tp.plugin.excel.ExTpl;
import io.vertx.tp.plugin.excel.Pool;
import io.vertx.tp.plugin.excel.SheetAnalyzer;
import io.vertx.tp.plugin.excel.atom.ExConnect;
import io.vertx.tp.plugin.excel.atom.ExTable;
import io.vertx.tp.plugin.excel.ranger.RowBound;
import io.vertx.up.commune.element.Shape;
import io.vertx.up.fn.Fn;
import io.vertx.up.util.Ut;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

class ExcelHelper {
    private static final Map<String, FormulaEvaluator> REFERENCES = new HashMap<String, FormulaEvaluator>();
    private final transient Class<?> target;
    private transient ExTpl tpl;

    private ExcelHelper(Class<?> target) {
        this.target = target;
    }

    static ExcelHelper helper(Class<?> target) {
        return (ExcelHelper)Fn.pool(Pool.HELPERS, (Object)target.getName(), () -> new ExcelHelper(target));
    }

    Workbook getWorkbook(String filename) {
        Fn.outWeb((null == filename ? 1 : 0) != 0, _404ExcelFileNullException.class, (Object[])new Object[]{this.target, filename});
        InputStream in = Ut.ioStream((String)filename);
        Fn.outWeb((null == in ? 1 : 0) != 0, _404ExcelFileNullException.class, (Object[])new Object[]{this.target, filename});
        Workbook workbook = filename.endsWith("xls") ? (Workbook)Fn.pool(Pool.WORKBOOKS, (Object)filename, () -> (HSSFWorkbook)Fn.getJvm(() -> new HSSFWorkbook(in), (Object[])new Object[0])) : (Workbook)Fn.pool(Pool.WORKBOOKS, (Object)filename, () -> (XSSFWorkbook)Fn.getJvm(() -> new XSSFWorkbook(in), (Object[])new Object[0]));
        return workbook;
    }

    Workbook getWorkbook(InputStream in, boolean isXlsx) {
        Fn.outWeb((null == in ? 1 : 0) != 0, _404ExcelFileNullException.class, (Object[])new Object[]{this.target, "Stream"});
        Workbook workbook = isXlsx ? (Workbook)Fn.pool(Pool.WORKBOOKS_STREAM, (Object)in.hashCode(), () -> (XSSFWorkbook)Fn.getJvm(() -> new XSSFWorkbook(in), (Object[])new Object[0])) : (Workbook)Fn.pool(Pool.WORKBOOKS_STREAM, (Object)in.hashCode(), () -> (HSSFWorkbook)Fn.getJvm(() -> new HSSFWorkbook(in), (Object[])new Object[0]));
        return workbook;
    }

    Set<ExTable> getExTables(Workbook workbook, Shape shape) {
        return (Set)Fn.getNull(new HashSet(), () -> {
            FormulaEvaluator evaluator = workbook.getCreationHelper().createFormulaEvaluator();
            HashMap<String, FormulaEvaluator> references = new HashMap<String, FormulaEvaluator>(REFERENCES);
            if (!references.isEmpty()) {
                references.put(workbook.createName().getNameName(), evaluator);
                evaluator.setupReferencedWorkbooks(references);
            }
            Iterator it = workbook.sheetIterator();
            HashSet<ExTable> sheets = new HashSet<ExTable>();
            while (it.hasNext()) {
                Sheet sheet = (Sheet)it.next();
                RowBound range = new RowBound(sheet);
                SheetAnalyzer exSheet = new SheetAnalyzer(sheet).on(evaluator);
                sheets.addAll(exSheet.analyzed(range, shape));
            }
            return sheets;
        }, (Object[])new Object[]{workbook});
    }

    void brush(Workbook workbook, Sheet sheet, Shape shape) {
        if (Objects.nonNull(this.tpl)) {
            this.tpl.bind(workbook);
            this.tpl.applyStyle(sheet, shape);
        }
    }

    void initPen(String componentStr) {
        Class tplCls;
        if (Ut.notNil((String)componentStr) && Ut.isImplement((Class)(tplCls = Ut.clazz((String)componentStr, null)), ExTpl.class)) {
            this.tpl = (ExTpl)Ut.singleton((String)componentStr, (Object[])new Object[0]);
        }
    }

    void initConnect(JsonArray connects) {
        if (Pool.CONNECTS.isEmpty()) {
            List connectList = Ut.deserialize((JsonArray)connects, (TypeReference)new TypeReference<List<ExConnect>>(){});
            connectList.stream().filter(Objects::nonNull).filter(connect -> Objects.nonNull(connect.getTable())).forEach(connect -> Pool.CONNECTS.put(connect.getTable(), (ExConnect)connect));
        }
    }

    void initEnvironment(JsonArray environments) {
        environments.stream().filter(Objects::nonNull).map(item -> (JsonObject)item).forEach(each -> {
            String key = each.getString("name");
            String path = each.getString("path");
            Workbook workbook = this.getWorkbook(path);
            FormulaEvaluator evaluator = workbook.getCreationHelper().createFormulaEvaluator();
            if (Objects.nonNull(evaluator)) {
                REFERENCES.put(key, evaluator);
            }
        });
    }
}

