/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.excel;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.error._500ExportingErrorException;
import io.vertx.tp.plugin.excel.ExcelHelper;
import io.vertx.tp.plugin.excel.tool.ExFn;
import io.vertx.up.commune.element.Shape;
import io.vertx.up.exception.web._500InternalServerException;
import io.vertx.up.fn.Fn;
import io.vertx.up.util.Ut;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

class SheetExport {
    private final transient ExcelHelper helper;

    private SheetExport(ExcelHelper helper) {
        this.helper = helper;
    }

    static SheetExport create(ExcelHelper helper) {
        return new SheetExport(helper);
    }

    void exportData(String identifier, JsonArray data, Shape shape, Handler<AsyncResult<Buffer>> handler) {
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet sheet = workbook.createSheet(identifier);
        boolean headed = ExFn.generateHeader((Sheet)sheet, identifier, data, shape);
        ArrayList<Integer> sizeList = new ArrayList<Integer>();
        List<Class<?>> types = this.types(data, shape);
        Ut.itJArray((JsonArray)data, JsonArray.class, (rowData, index) -> {
            Integer actualIdx = headed ? index + 1 : index;
            if (shape.isComplex()) {
                if (actualIdx <= 4) {
                    ExFn.generateHeader((Sheet)sheet, actualIdx, rowData);
                } else {
                    ExFn.generateData((Sheet)sheet, actualIdx, rowData, types);
                }
            } else if (actualIdx <= 2) {
                ExFn.generateHeader((Sheet)sheet, actualIdx, rowData);
            } else {
                ExFn.generateData((Sheet)sheet, actualIdx, rowData, types);
            }
            sizeList.add(rowData.size());
        });
        this.helper.brush((Workbook)workbook, (Sheet)sheet, shape);
        ExFn.generateAdjust((Sheet)sheet, sizeList);
        Fn.safeJvm(() -> {
            String filename = identifier + "." + UUID.randomUUID() + "." + "xlsx";
            FileOutputStream out = new FileOutputStream(filename);
            workbook.write((OutputStream)out);
            handler.handle((Object)Future.succeededFuture((Object)Ut.ioBuffer((String)filename)));
        });
    }

    Future<Buffer> exportData(String identifier, JsonArray data, Shape shape) {
        Promise promise = Promise.promise();
        this.exportData(identifier, data, shape, this.callback((Promise<Buffer>)promise));
        return promise.future();
    }

    private List<Class<?>> types(JsonArray data, Shape shape) {
        ArrayList typeArray = new ArrayList();
        if (Objects.nonNull(shape) && shape.isComplex()) {
            JsonArray fields = data.getJsonArray(2);
            JsonArray secondary = data.getJsonArray(3);
            if (Ut.notNil((JsonArray)fields) && Ut.notNil((JsonArray)secondary)) {
                ConcurrentHashMap<Integer, String> parentMap = new ConcurrentHashMap<Integer, String>();
                String found = null;
                int length = fields.size();
                for (int idx = 0; idx < length; ++idx) {
                    Object item2 = fields.getValue(idx);
                    String field = this.typeField(item2);
                    if (Ut.notNil((String)field)) {
                        Class type = shape.type(field);
                        if (JsonArray.class != type) {
                            typeArray.add(type);
                            continue;
                        }
                        found = field;
                        parentMap.put(idx, found);
                        continue;
                    }
                    parentMap.put(idx, found);
                }
                int lengthChild = secondary.size();
                for (int idx = 0; idx < lengthChild; ++idx) {
                    Object item3 = secondary.getValue(idx);
                    String field = this.typeField(item3);
                    String parent = parentMap.getOrDefault(idx, null);
                    if (!Ut.notNil((String)field) || !Ut.notNil((String)parent)) continue;
                    typeArray.add(shape.type(parent, field));
                }
            }
        } else {
            JsonArray fields = data.getJsonArray(1);
            if (Ut.notNil((JsonArray)fields)) {
                fields.forEach(item -> {
                    String field = this.typeField(item);
                    typeArray.add(shape.type(field));
                });
            }
        }
        return typeArray;
    }

    private String typeField(Object input) {
        if (Objects.isNull(input)) {
            return null;
        }
        if (input instanceof JsonObject) {
            return ((JsonObject)input).getString("value");
        }
        return (String)input;
    }

    private Handler<AsyncResult<Buffer>> callback(Promise<Buffer> promise) {
        return handler -> {
            if (handler.succeeded()) {
                promise.complete(handler.result());
            } else {
                Throwable error = handler.cause();
                if (Objects.nonNull(error)) {
                    _500ExportingErrorException failure = new _500ExportingErrorException(this.getClass(), error.getMessage());
                    promise.fail((Throwable)((Object)failure));
                } else {
                    promise.fail((Throwable)new _500InternalServerException(this.getClass(), "Unexpected Error when Exporting"));
                }
            }
        };
    }
}

