/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.excel;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.error._500ExportingErrorException;
import io.vertx.tp.plugin.excel.ExcelClientImpl;
import io.vertx.tp.plugin.excel.ExcelHelper;
import io.vertx.tp.plugin.excel.atom.ExRecord;
import io.vertx.tp.plugin.excel.atom.ExTable;
import io.vertx.up.exception.web._500InternalServerException;
import io.vertx.up.log.Annal;
import io.vertx.up.unity.Ux;
import io.vertx.up.unity.jq.UxJooq;
import io.vertx.up.util.Ut;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

class SheetImport {
    private static final Annal LOGGER = Annal.get(ExcelClientImpl.class);
    private final transient ExcelHelper helper;

    private SheetImport(ExcelHelper helper) {
        this.helper = helper;
    }

    static SheetImport create(ExcelHelper helper) {
        return new SheetImport(helper);
    }

    <T> T saveEntity(JsonObject data, ExTable table) {
        Object reference = null;
        if (Objects.nonNull(table.getPojo()) && Objects.nonNull(table.getDao())) {
            JsonObject filters = table.whereUnique(data);
            LOGGER.debug("[ \u0388\u03be\u03bf\u03b4\u03bf\u03c2 ] Filters: {0}, Table: {1}", new Object[]{filters.encode(), table.getName()});
            Object entity = Ux.fromJson((JsonObject)data, table.getPojo(), (String)table.getPojoFile());
            UxJooq jooq = Ux.Jooq.on(table.getDao());
            if (null != jooq) {
                Object fetched;
                String key;
                Object queried;
                String pojoFile = table.getPojoFile();
                if (Ut.notNil((String)pojoFile)) {
                    jooq.on(pojoFile);
                }
                reference = null == (queried = jooq.fetchOne(filters)) ? (Ut.isNil((String)(key = (String)table.whereKey(data))) ? jooq.insert(entity) : (null == (fetched = jooq.findById((Object)key)) ? jooq.insert(entity) : jooq.update(entity))) : jooq.update(entity);
            }
        }
        return (T)reference;
    }

    <T> Future<Set<T>> importAsync(Set<ExTable> tables) {
        HashSet entitySet = new HashSet();
        tables.forEach(table -> this.extract((ExTable)table).forEach(json -> {
            Object entity = this.saveEntity((JsonObject)json, (ExTable)table);
            if (Objects.nonNull(entity)) {
                entitySet.add(entity);
            }
        }));
        return Future.succeededFuture(entitySet);
    }

    <T> Future<Set<T>> importAsync(AsyncResult<Set<ExTable>> async) {
        if (async.succeeded()) {
            Set tables = (Set)async.result();
            return this.importAsync(tables);
        }
        Throwable error = async.cause();
        if (Objects.nonNull(error)) {
            return Future.failedFuture((Throwable)((Object)new _500ExportingErrorException(this.getClass(), error.getMessage())));
        }
        return Future.failedFuture((Throwable)new _500InternalServerException(this.getClass(), "Unexpected Error when Importing"));
    }

    private List<JsonObject> extract(ExTable table) {
        List<ExRecord> records = table.get();
        LOGGER.info("[ \u0388\u03be\u03bf\u03b4\u03bf\u03c2 ] Table: {0}, Data Size: {1}", new Object[]{table.getName(), records.size()});
        return records.stream().filter(Objects::nonNull).map(ExRecord::toJson).collect(Collectors.toList());
    }
}

