/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.excel.atom;

import io.vertx.core.json.JsonObject;
import io.vertx.tp.plugin.excel.cell.ExValue;
import io.vertx.up.commune.Json;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;

public class ExRecord
implements Serializable,
Json {
    private final transient Map<String, Object> data = new HashMap<String, Object>();

    public void put(String field, Object value) {
        this.data.put(field, ExValue.get(value).to(value));
    }

    public <T> T get(String field) {
        Object value = this.data.get(field);
        return (T)(null == value ? null : value);
    }

    public boolean isEmpty() {
        return this.toJson().isEmpty();
    }

    public String toString() {
        StringBuilder content = new StringBuilder();
        this.data.forEach((key, value) -> content.append((String)key).append("=").append(value).append(","));
        return content.toString();
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        this.data.forEach((key, value) -> this.consume((String)key, value, (arg_0, arg_1) -> ((JsonObject)json).put(arg_0, arg_1)));
        return json;
    }

    public void fromJson(JsonObject json) {
        if (null != json) {
            this.data.clear();
            json.stream().forEach(entry -> this.consume((String)entry.getKey(), entry.getValue(), this.data::put));
        }
    }

    private void consume(String key, Object value, BiConsumer<String, Object> consumer) {
        if (Objects.nonNull(value)) {
            consumer.accept(key, value);
        }
    }
}

