/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.excel.cell;

import io.vertx.tp.plugin.excel.cell.Pool;
import io.vertx.tp.plugin.excel.cell.PureValue;
import io.vertx.tp.plugin.excel.tool.ExIo;
import io.vertx.up.util.Ut;
import java.util.Objects;
import java.util.function.Function;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.FormulaEvaluator;

@FunctionalInterface
public interface ExValue {
    public static ExValue get(Object value) {
        if (Objects.isNull(value)) {
            return (ExValue)Ut.singleton(PureValue.class, (Object[])new Object[0]);
        }
        ExValue reference = (ExValue)Pool.VALUE_MAP.get(value);
        if (Objects.isNull(reference)) {
            String literal = value.toString();
            if (literal.startsWith("JSON")) {
                reference = (ExValue)Pool.PREFIX_MAP.get("JSON");
            }
            if (Objects.isNull(reference)) {
                return (ExValue)Ut.singleton(PureValue.class, (Object[])new Object[0]);
            }
            return reference;
        }
        return reference;
    }

    public static Object getValue(Cell cell, Class<?> type, FormulaEvaluator evaluator) {
        CellType switchedType;
        CellValue value;
        String exprValue;
        String exprOr;
        CellType cellType = cell.getCellType();
        if (CellType.BLANK == cellType || CellType.ERROR == cellType) {
            return null;
        }
        if (CellType.FORMULA == cellType && Objects.nonNull(evaluator) && Ut.isNil((String)(exprOr = "NULL".equalsIgnoreCase((exprValue = (value = evaluator.evaluate(cell)).getStringValue()).trim()) ? null : exprValue))) {
            return null;
        }
        Function fun = CellType.FORMULA == cellType ? (Function)Pool.FUNS.get(CellType.STRING) : (Objects.nonNull(type) ? (Objects.isNull(switchedType = ExIo.type(type)) ? (Function)Pool.FUNS.get(cellType) : (Function)Pool.FUNS.get(switchedType)) : (Function)Pool.FUNS.get(cellType));
        if (Objects.isNull(fun)) {
            return null;
        }
        return fun.apply(cell);
    }

    public <T> T to(Object var1);
}

