/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.excel.ranger;

import io.vertx.tp.plugin.excel.ranger.ExBound;
import java.util.Objects;
import org.apache.poi.ss.usermodel.Sheet;

public class RowBound
implements ExBound {
    private final transient int start;
    private final transient int end;

    public RowBound(Sheet sheet) {
        this(sheet.getFirstRowNum(), sheet.getLastRowNum());
    }

    public RowBound(int start, int end) {
        this.start = start;
        this.end = end;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RowBound)) {
            return false;
        }
        RowBound rowBound = (RowBound)o;
        return this.start == rowBound.start && this.end == rowBound.end;
    }

    public int hashCode() {
        return Objects.hash(this.start, this.end);
    }

    public String toString() {
        return "RowBound{begin=" + this.start + ", end=" + this.end + '}';
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public int getEnd() {
        return this.end;
    }
}

