/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.excel.tpl;

import io.vertx.tp.plugin.excel.tpl.DyeCell;
import io.vertx.up.fn.Fn;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;

class BlueDye {
    private static final ConcurrentMap<Integer, BlueDye> PICKER_POOL = new ConcurrentHashMap<Integer, BlueDye>();
    private final ConcurrentMap<String, DyeCell> stylePool = new ConcurrentHashMap<String, DyeCell>();
    private final transient Workbook workbook;

    private BlueDye(Workbook workbook) {
        this.workbook = workbook;
    }

    static BlueDye get(Workbook workbook) {
        return (BlueDye)Fn.pool(PICKER_POOL, (Object)workbook.hashCode(), () -> new BlueDye(workbook));
    }

    void onTable(Cell cell) {
        DyeCell dyeCell = (DyeCell)Fn.pool(this.stylePool, (Object)"TABLE", () -> DyeCell.create(this.workbook).color("FFFFFF", "3EB7FF").align(HorizontalAlignment.CENTER).border(BorderStyle.THIN).font(13, false));
        cell.setCellStyle(dyeCell.build());
    }

    void onModel(Cell cell) {
        DyeCell dyeCell = (DyeCell)Fn.pool(this.stylePool, (Object)"MODEL", () -> DyeCell.create(this.workbook).color("FFFFFF", "696969").align(HorizontalAlignment.CENTER).border(BorderStyle.THIN).font(13, false));
        cell.setCellStyle(dyeCell.build());
    }

    void onEmpty(Cell cell) {
        DyeCell dyeCell = (DyeCell)Fn.pool(this.stylePool, (Object)"EMPTY", () -> DyeCell.create(this.workbook).align(HorizontalAlignment.CENTER).border(BorderStyle.THIN));
        cell.setCellStyle(dyeCell.build());
    }

    void onCnHeader(Cell cell) {
        this.onTable(cell);
    }

    void onEnHeader(Cell cell) {
        DyeCell dyeCell = (DyeCell)Fn.pool(this.stylePool, (Object)"HEADER", () -> DyeCell.create(this.workbook).color("000000", "FFEC8B").align(HorizontalAlignment.CENTER).border(BorderStyle.THIN).font(13, false));
        cell.setCellStyle(dyeCell.build());
    }

    void onData(Cell cell) {
        DyeCell dyeCell = (DyeCell)Fn.pool(this.stylePool, (Object)"DATA", () -> DyeCell.create(this.workbook).border(BorderStyle.THIN).align(null, VerticalAlignment.TOP).font(13, false));
        cell.setCellStyle(dyeCell.build());
    }
}

