/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.excel.tpl;

import java.awt.Color;
import java.io.Serializable;
import java.util.Objects;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;

public class DyeCell
implements Serializable {
    private final transient XSSFFont font;
    private final transient XSSFCellStyle style;

    private DyeCell(Workbook workbook) {
        this.style = (XSSFCellStyle)workbook.createCellStyle();
        this.font = (XSSFFont)workbook.createFont();
    }

    public static DyeCell create(Workbook workbook) {
        return new DyeCell(workbook);
    }

    public DyeCell align(HorizontalAlignment align, VerticalAlignment valign) {
        if (Objects.nonNull(align)) {
            this.style.setAlignment(align);
        }
        this.style.setVerticalAlignment(valign);
        return this;
    }

    public DyeCell align(HorizontalAlignment align) {
        this.align(align, VerticalAlignment.TOP);
        return this;
    }

    public DyeCell color(String fore, String bg) {
        XSSFColor foreColor = this.build(fore);
        XSSFColor bgColor = this.build(bg);
        return this.color(foreColor, bgColor);
    }

    private DyeCell color(XSSFColor fore, XSSFColor bg) {
        this.font.setColor(fore);
        this.style.setFillForegroundColor(bg);
        this.style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        return this;
    }

    private XSSFColor build(String color) {
        int r = Integer.parseInt(color.substring(0, 2), 16);
        int g = Integer.parseInt(color.substring(2, 4), 16);
        int b = Integer.parseInt(color.substring(4, 6), 16);
        Color awtColor = new Color(r, g, b);
        return new XSSFColor(awtColor, null);
    }

    public DyeCell border(BorderStyle ... borders) {
        return this.border((Short)null, borders);
    }

    public DyeCell border(Short color, BorderStyle ... borders) {
        if (0 < borders.length) {
            if (1 == borders.length) {
                this.style.setBorderTop(borders[0]);
                this.style.setBorderRight(borders[0]);
                this.style.setBorderBottom(borders[0]);
                this.style.setBorderLeft(borders[0]);
            } else if (2 == borders.length) {
                this.style.setBorderTop(borders[0]);
                this.style.setBorderRight(borders[1]);
                this.style.setBorderBottom(borders[0]);
                this.style.setBorderLeft(borders[1]);
            } else if (3 == borders.length) {
                this.style.setBorderTop(borders[0]);
                this.style.setBorderRight(borders[1]);
                this.style.setBorderBottom(borders[2]);
                this.style.setBorderLeft(borders[1]);
            } else if (4 == borders.length) {
                this.style.setBorderTop(borders[0]);
                this.style.setBorderRight(borders[1]);
                this.style.setBorderBottom(borders[2]);
                this.style.setBorderLeft(borders[3]);
            }
        }
        if (Objects.nonNull(color)) {
            this.style.setTopBorderColor(color.shortValue());
            this.style.setRightBorderColor(color.shortValue());
            this.style.setBottomBorderColor(color.shortValue());
            this.style.setLeftBorderColor(color.shortValue());
        }
        return this;
    }

    public DyeCell wrap() {
        this.style.setWrapText(true);
        return this;
    }

    public DyeCell unwrap() {
        this.style.setWrapText(false);
        return this;
    }

    public DyeCell font(int fontSize, boolean bold) {
        return this.font(fontSize, bold, null, null);
    }

    public DyeCell font(int fontSize, boolean bold, short color) {
        return this.font(fontSize, bold, color, null);
    }

    public DyeCell font(int fontSize, boolean bold, Short color, String name) {
        this.font.setFontHeightInPoints((short)fontSize);
        if (Objects.nonNull(color)) {
            this.font.setColor(color.shortValue());
        }
        this.font.setBold(bold);
        if (Objects.nonNull(name)) {
            this.font.setFontName(name);
        }
        return this;
    }

    public CellStyle build() {
        this.style.setFont((Font)this.font);
        return this.style;
    }
}

