/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.excel;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.tp.error._500ExportingErrorException;
import io.vertx.tp.plugin.excel.ExcelHelper;
import io.vertx.tp.plugin.excel.tool.ExFn;
import io.vertx.up.commune.element.TypeAtom;
import io.vertx.up.exception.web._500InternalServerException;
import io.vertx.up.fn.Fn;
import io.vertx.up.util.Ut;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Objects;
import java.util.UUID;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

class SheetExport {
    private final transient ExcelHelper helper;

    private SheetExport(ExcelHelper helper) {
        this.helper = helper;
    }

    static SheetExport create(ExcelHelper helper) {
        return new SheetExport(helper);
    }

    void exportData(String identifier, JsonArray data, TypeAtom TypeAtom2, Handler<AsyncResult<Buffer>> handler) {
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet sheet = workbook.createSheet(identifier);
        boolean headed = ExFn.generateHeader((Sheet)sheet, identifier, data, TypeAtom2);
        ArrayList<Integer> sizeList = new ArrayList<Integer>();
        if (Objects.nonNull(TypeAtom2)) {
            TypeAtom2.analyzed(data);
        }
        Ut.itJArray((JsonArray)data, JsonArray.class, (rowData, index) -> {
            Integer actualIdx = headed ? index + 1 : index;
            if (TypeAtom2.isComplex()) {
                if (actualIdx <= 4) {
                    ExFn.generateHeader((Sheet)sheet, actualIdx, rowData);
                } else {
                    ExFn.generateData((Sheet)sheet, actualIdx, rowData, TypeAtom2.types());
                }
            } else if (actualIdx <= 2) {
                ExFn.generateHeader((Sheet)sheet, actualIdx, rowData);
            } else {
                ExFn.generateData((Sheet)sheet, actualIdx, rowData, TypeAtom2.types());
            }
            sizeList.add(rowData.size());
        });
        this.helper.brush((Workbook)workbook, (Sheet)sheet, TypeAtom2);
        ExFn.generateAdjust((Sheet)sheet, sizeList);
        Fn.safeJvm(() -> {
            String filename = identifier + "." + UUID.randomUUID() + "." + "xlsx";
            FileOutputStream out = new FileOutputStream(filename);
            workbook.write((OutputStream)out);
            handler.handle((Object)Future.succeededFuture((Object)Ut.ioBuffer((String)filename)));
        });
    }

    Future<Buffer> exportData(String identifier, JsonArray data, TypeAtom TypeAtom2) {
        Promise promise = Promise.promise();
        this.exportData(identifier, data, TypeAtom2, this.callback((Promise<Buffer>)promise));
        return promise.future();
    }

    private Handler<AsyncResult<Buffer>> callback(Promise<Buffer> promise) {
        return handler -> {
            if (handler.succeeded()) {
                promise.complete(handler.result());
            } else {
                Throwable error = handler.cause();
                if (Objects.nonNull(error)) {
                    _500ExportingErrorException failure = new _500ExportingErrorException(this.getClass(), error.getMessage());
                    promise.fail((Throwable)((Object)failure));
                } else {
                    promise.fail((Throwable)new _500InternalServerException(this.getClass(), "Unexpected Error when Exporting"));
                }
            }
        };
    }
}

