/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.excel.cell;

import io.vertx.up.util.Ut;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.TimeZone;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;

class DataValue {
    DataValue() {
    }

    static Object toBoolean(Cell cell) {
        if (CellType.BOOLEAN == cell.getCellType()) {
            return cell.getBooleanCellValue();
        }
        String literal = cell.getStringCellValue();
        if (Ut.isNil((String)literal)) {
            return Boolean.FALSE;
        }
        return Boolean.valueOf(literal);
    }

    static Object toString(Cell cell) {
        if (CellType.NUMERIC == cell.getCellType()) {
            return String.valueOf(cell.getNumericCellValue());
        }
        return cell.getStringCellValue();
    }

    static Object toNumeric(Cell cell) {
        if (CellType.NUMERIC == cell.getCellType()) {
            if (DateUtil.isCellDateFormatted((Cell)cell)) {
                double cellValue = cell.getNumericCellValue();
                if (DateUtil.isValidExcelDate((double)cellValue)) {
                    Date date = DateUtil.getJavaDate((double)cellValue, (TimeZone)TimeZone.getDefault());
                    LocalDateTime dateTime = Ut.toDateTime((Date)date);
                    if (dateTime.getYear() < 1900) {
                        LocalTime time = Ut.toTime((Date)date);
                        return time.format(DateTimeFormatter.ISO_LOCAL_TIME);
                    }
                    return date.toInstant();
                }
                return null;
            }
            return cell.getNumericCellValue();
        }
        return null;
    }
}

