/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.excel.ranger;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.plugin.excel.atom.ExRecord;
import io.vertx.tp.plugin.excel.atom.ExTable;
import io.vertx.tp.plugin.excel.ranger.AbstractExIn;
import io.vertx.tp.plugin.excel.ranger.ColBound;
import io.vertx.tp.plugin.excel.ranger.ExBound;
import io.vertx.tp.plugin.excel.ranger.RowBound;
import io.vertx.tp.plugin.excel.tool.ExFn;
import io.vertx.up.atom.Refer;
import io.vertx.up.commune.element.TypeAtom;
import io.vertx.up.util.Ut;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public class ComplexIn
extends AbstractExIn {
    public ComplexIn(Sheet sheet) {
        super(sheet);
    }

    @Override
    public ExBound applyTable(ExTable table, Row row, Cell cell, Integer limitation) {
        Refer hod = new Refer();
        ExFn.onRow(this.sheet, row.getRowNum() + 3, row.getRowNum() + 4, (found, foundRow) -> {
            ColBound bound = new ColBound(cell.getColumnIndex(), found.getLastCellNum());
            Refer foundParent = new Refer();
            ExFn.itRowZip(found, foundRow, bound, (first, second) -> {
                String parent = first.getStringCellValue();
                String child = second.getStringCellValue();
                if (Ut.notNil((String)parent) || Ut.notNil((String)child)) {
                    if (Ut.isNil((String)child) && Ut.notNil((String)parent)) {
                        table.add(parent);
                    } else if (Ut.notNil((String)child) && Ut.notNil((String)parent)) {
                        foundParent.add((Object)parent);
                        table.add(parent, child);
                    } else if (Ut.notNil((String)child) && Ut.isNil((String)parent)) {
                        table.add((String)foundParent.get(), child);
                    }
                }
            });
            hod.add((Object)new RowBound(foundRow.getRowNum() + 1, limitation));
        });
        return (ExBound)hod.get();
    }

    @Override
    public ExTable applyData(ExTable table, ExBound dataRange, Cell cell, TypeAtom TypeAtom2) {
        ColBound bound = new ColBound(cell.getColumnIndex(), cell.getColumnIndex() + table.size());
        Set<Integer> diffSet = table.indexDiff();
        ExFn.itSheet(this.sheet, dataRange, diffSet, rowList -> {
            ExRecord record = new ExRecord();
            ConcurrentHashMap<String, JsonArray> complexMap = new ConcurrentHashMap<String, JsonArray>();
            ConcurrentHashMap<String, JsonObject> rowMap = new ConcurrentHashMap<String, JsonObject>();
            Row row = (Row)rowList.get(0);
            ExFn.itRow(row, bound, this.cellConsumer(record, rowMap, table, TypeAtom2));
            this.extractComplex(complexMap, rowMap);
            int size = rowList.size();
            if (1 < size) {
                for (int idx = 1; idx < size; ++idx) {
                    Row dataRow = (Row)rowList.get(idx);
                    ExFn.itRow(dataRow, bound, this.cellConsumer(rowMap, table, TypeAtom2));
                    this.extractComplex(complexMap, rowMap);
                }
            }
            if (!complexMap.isEmpty()) {
                complexMap.forEach(record::put);
            }
            if (!record.isEmpty()) {
                table.add(record);
            }
        });
        return table;
    }

    private BiConsumer<Cell, Integer> cellConsumer(ExRecord record, ConcurrentMap<String, JsonObject> rowMap, ExTable table, TypeAtom TypeAtom2) {
        return (dataCell, cellIndex) -> {
            String field = table.field((int)cellIndex);
            if (Objects.nonNull(field)) {
                if (field.contains(".")) {
                    this.cellConsumer(rowMap, field).accept((Cell)dataCell, TypeAtom2);
                } else {
                    Class type = TypeAtom2.type(field);
                    Object value = this.extractValue((Cell)dataCell, type);
                    record.put(field, value);
                }
            } else {
                this.logger().warn("Field (index = {0}) could not be found", new Object[]{cellIndex});
            }
        };
    }

    private BiConsumer<Cell, Integer> cellConsumer(ConcurrentMap<String, JsonObject> rowMap, ExTable table, TypeAtom TypeAtom2) {
        return (dataCell, cellIndex) -> {
            String field = table.field((int)cellIndex);
            if (Objects.nonNull(field)) {
                if (field.contains(".")) {
                    this.cellConsumer(rowMap, field).accept((Cell)dataCell, TypeAtom2);
                }
            } else {
                this.logger().warn("Field (index = {0}) could not be found", new Object[]{cellIndex});
            }
        };
    }
}

