/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.excel;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.plugin.excel.ExcelClient;
import io.vertx.tp.plugin.excel.ExcelHelper;
import io.vertx.tp.plugin.excel.Pool;
import io.vertx.tp.plugin.excel.SheetExport;
import io.vertx.tp.plugin.excel.SheetImport;
import io.vertx.tp.plugin.excel.SheetIngest;
import io.vertx.tp.plugin.excel.atom.ExTable;
import io.vertx.tp.plugin.excel.atom.ExTenant;
import io.vertx.up.commune.element.TypeAtom;
import io.vertx.up.log.Annal;
import io.vertx.up.util.Ut;
import java.io.InputStream;
import java.util.Set;

public class ExcelClientImpl
implements ExcelClient {
    private static final Annal LOGGER = Annal.get(ExcelClientImpl.class);
    private final transient Vertx vertx;
    private final transient ExcelHelper helper = ExcelHelper.helper(this.getClass());
    private final transient SheetExport exporter = SheetExport.create(this.helper);
    private final transient SheetIngest ingest = SheetIngest.create(this.helper);
    private final transient SheetImport importer = SheetImport.create(this.helper);

    ExcelClientImpl(Vertx vertx, JsonObject config) {
        this.vertx = vertx;
        this.init(config);
    }

    @Override
    public ExcelClient init(JsonObject config) {
        JsonObject tenantJson;
        JsonArray mapping = config.getJsonArray("mapping");
        this.helper.initConnect(mapping);
        LOGGER.debug("[ \u0388\u03be\u03bf\u03b4\u03bf\u03c2 ] Configuration finished: {0}", new Object[]{Pool.CONNECTS.size()});
        if (config.containsKey("environment")) {
            JsonArray environments = config.getJsonArray("environment");
            this.helper.initEnvironment(environments);
            LOGGER.debug("[ \u0388\u03be\u03bf\u03b4\u03bf\u03c2 ] Configuration environments: {0}", new Object[]{environments.encode()});
        }
        if (config.containsKey("pen")) {
            String componentStr = config.getString("pen");
            this.helper.initPen(componentStr);
            LOGGER.debug("[ \u0388\u03be\u03bf\u03b4\u03bf\u03c2 ] Configuration pen for Exporting: {0}", new Object[]{componentStr});
        }
        if (config.containsKey("tenant") && Ut.notNil((JsonObject)(tenantJson = Ut.ioJObject((String)config.getString("tenant"))))) {
            ExTenant tenant = (ExTenant)Ut.deserialize((JsonObject)tenantJson, ExTenant.class);
            this.helper.initTenant(tenant);
            LOGGER.debug("[ \u0388\u03be\u03bf\u03b4\u03bf\u03c2 ] Configuration tenant for Importing: {0}", new Object[]{tenantJson.encode()});
        }
        return this;
    }

    @Override
    public Set<ExTable> ingest(String filename) {
        return this.ingest.ingest(filename);
    }

    @Override
    public Set<ExTable> ingest(String filename, TypeAtom typeAtom) {
        return this.ingest.ingest(filename, typeAtom);
    }

    @Override
    public Set<ExTable> ingest(InputStream in, boolean isXlsx) {
        return this.ingest.ingest(in, isXlsx);
    }

    @Override
    public Set<ExTable> ingest(InputStream in, boolean isXlsx, TypeAtom typeAtom) {
        return this.ingest.ingest(in, isXlsx, typeAtom);
    }

    @Override
    public Future<Set<ExTable>> ingestAsync(String filename) {
        return Future.succeededFuture(this.ingest(filename));
    }

    @Override
    public Future<Set<ExTable>> ingestAsync(String filename, TypeAtom typeAtom) {
        return Future.succeededFuture(this.ingest(filename, typeAtom));
    }

    @Override
    public Future<Set<ExTable>> ingestAsync(InputStream in, boolean isXlsx) {
        return Future.succeededFuture(this.ingest(in, isXlsx));
    }

    @Override
    public Future<Set<ExTable>> ingestAsync(InputStream in, boolean isXlsx, TypeAtom typeAtom) {
        return Future.succeededFuture(this.ingest(in, isXlsx, typeAtom));
    }

    @Override
    @Fluent
    public ExcelClient ingest(String filename, Handler<AsyncResult<Set<ExTable>>> handler) {
        handler.handle(this.ingestAsync(filename));
        return this;
    }

    @Override
    @Fluent
    public ExcelClient ingest(String filename, TypeAtom typeAtom, Handler<AsyncResult<Set<ExTable>>> handler) {
        handler.handle(this.ingestAsync(filename, typeAtom));
        return this;
    }

    @Override
    @Fluent
    public ExcelClient ingest(InputStream in, boolean isXlsx, Handler<AsyncResult<Set<ExTable>>> handler) {
        handler.handle(this.ingestAsync(in, isXlsx));
        return this;
    }

    @Override
    @Fluent
    public ExcelClient ingest(InputStream in, boolean isXlsx, TypeAtom typeAtom, Handler<AsyncResult<Set<ExTable>>> handler) {
        handler.handle(this.ingestAsync(in, isXlsx, typeAtom));
        return this;
    }

    @Override
    @Fluent
    public <T> ExcelClient importAsync(String filename, Handler<AsyncResult<Set<T>>> handler) {
        return this.ingest(filename, (Handler<AsyncResult<Set<ExTable>>>)((Handler)res -> handler.handle(this.importer.importAsync((AsyncResult<Set<ExTable>>)res))));
    }

    @Override
    @Fluent
    public <T> ExcelClient importAsync(InputStream in, boolean isXlsx, Handler<AsyncResult<Set<T>>> handler) {
        return this.ingest(in, isXlsx, (Handler<AsyncResult<Set<ExTable>>>)((Handler)res -> handler.handle(this.importer.importAsync((AsyncResult<Set<ExTable>>)res))));
    }

    @Override
    public <T> ExcelClient importAsync(String filename, TypeAtom typeAtom, Handler<AsyncResult<Set<T>>> handler) {
        return this.ingest(filename, typeAtom, (Handler<AsyncResult<Set<ExTable>>>)((Handler)res -> handler.handle(this.importer.importAsync((AsyncResult<Set<ExTable>>)res))));
    }

    @Override
    public <T> ExcelClient importAsync(InputStream in, boolean isXlsx, TypeAtom typeAtom, Handler<AsyncResult<Set<T>>> handler) {
        return this.ingest(in, isXlsx, typeAtom, (Handler<AsyncResult<Set<ExTable>>>)((Handler)res -> handler.handle(this.importer.importAsync((AsyncResult<Set<ExTable>>)res))));
    }

    @Override
    public <T> Future<Set<T>> importAsync(String filename) {
        return this.ingestAsync(filename).compose(this.importer::importAsync);
    }

    @Override
    public <T> Future<Set<T>> importAsync(String filename, TypeAtom typeAtom) {
        return this.ingestAsync(filename, typeAtom).compose(this.importer::importAsync);
    }

    @Override
    public <T> Future<Set<T>> importAsync(InputStream in, boolean isXlsx) {
        return this.ingestAsync(in, isXlsx).compose(this.importer::importAsync);
    }

    @Override
    public <T> Future<Set<T>> importAsync(InputStream in, boolean isXlsx, TypeAtom typeAtom) {
        return this.ingestAsync(in, isXlsx, typeAtom).compose(this.importer::importAsync);
    }

    @Override
    public <T> ExcelClient importAsync(String filename, Handler<AsyncResult<Set<T>>> handler, String ... includes) {
        return this.ingest(filename, (Handler<AsyncResult<Set<ExTable>>>)((Handler)res -> handler.handle(this.importer.importAsync((AsyncResult<Set<ExTable>>)this.ingest.compressAsync((Set)res.result(), includes)))));
    }

    @Override
    public <T> ExcelClient importAsync(String filename, TypeAtom typeAtom, Handler<AsyncResult<Set<T>>> handler, String ... includes) {
        return this.ingest(filename, typeAtom, (Handler<AsyncResult<Set<ExTable>>>)((Handler)res -> handler.handle(this.importer.importAsync((AsyncResult<Set<ExTable>>)this.ingest.compressAsync((Set)res.result(), includes)))));
    }

    @Override
    public <T> ExcelClient importAsync(InputStream in, boolean isXlsx, Handler<AsyncResult<Set<T>>> handler, String ... includes) {
        return this.ingest(in, isXlsx, (Handler<AsyncResult<Set<ExTable>>>)((Handler)res -> handler.handle(this.importer.importAsync((AsyncResult<Set<ExTable>>)this.ingest.compressAsync((Set)res.result(), includes)))));
    }

    @Override
    public <T> ExcelClient importAsync(InputStream in, boolean isXlsx, TypeAtom typeAtom, Handler<AsyncResult<Set<T>>> handler, String ... includes) {
        return this.ingest(in, isXlsx, typeAtom, (Handler<AsyncResult<Set<ExTable>>>)((Handler)res -> handler.handle(this.importer.importAsync((AsyncResult<Set<ExTable>>)this.ingest.compressAsync((Set)res.result(), includes)))));
    }

    @Override
    public <T> Future<Set<T>> importAsync(String filename, String ... includes) {
        return this.ingestAsync(filename).compose(tables -> this.ingest.compressAsync((Set<ExTable>)tables, includes)).compose(this.importer::importAsync);
    }

    @Override
    public <T> Future<Set<T>> importAsync(String filename, TypeAtom typeAtom, String ... includes) {
        return this.ingestAsync(filename, typeAtom).compose(tables -> this.ingest.compressAsync((Set<ExTable>)tables, includes)).compose(this.importer::importAsync);
    }

    @Override
    public <T> Future<Set<T>> importAsync(InputStream in, boolean isXlsx, String ... includes) {
        return this.ingestAsync(in, isXlsx).compose(tables -> this.ingest.compressAsync((Set<ExTable>)tables, includes)).compose(this.importer::importAsync);
    }

    @Override
    public <T> Future<Set<T>> importAsync(InputStream in, boolean isXlsx, TypeAtom typeAtom, String ... includes) {
        return this.ingestAsync(in, isXlsx, typeAtom).compose(tables -> this.ingest.compressAsync((Set<ExTable>)tables, includes)).compose(this.importer::importAsync);
    }

    @Override
    public ExcelClient exportAsync(String identifier, JsonArray data, Handler<AsyncResult<Buffer>> handler) {
        this.exporter.exportData(identifier, data, TypeAtom.create(), handler);
        return this;
    }

    @Override
    public ExcelClient exportAsync(String identifier, JsonArray data, TypeAtom typeAtom, Handler<AsyncResult<Buffer>> handler) {
        this.exporter.exportData(identifier, data, typeAtom, handler);
        return this;
    }

    @Override
    public Future<Buffer> exportAsync(String identifier, JsonArray data, TypeAtom typeAtom) {
        return this.exporter.exportData(identifier, data, typeAtom);
    }

    @Override
    public Future<Buffer> exportAsync(String identifier, JsonArray data) {
        return this.exporter.exportData(identifier, data, TypeAtom.create());
    }

    @Override
    public Future<JsonArray> extractAsync(ExTable table) {
        return this.helper.extract(table);
    }

    @Override
    public Future<JsonArray> extractAsync(Set<ExTable> tables) {
        return this.helper.extract(tables);
    }
}

