/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.excel.atom;

import com.fasterxml.jackson.databind.JsonArrayDeserializer;
import com.fasterxml.jackson.databind.JsonArraySerializer;
import com.fasterxml.jackson.databind.JsonObjectDeserializer;
import com.fasterxml.jackson.databind.JsonObjectSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.plugin.excel.ExcelClient;
import io.vertx.tp.plugin.excel.ExcelInfix;
import io.vertx.tp.plugin.excel.atom.ExRecord;
import io.vertx.up.atom.Kv;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ExTenant
implements Serializable {
    @JsonSerialize(using=JsonObjectSerializer.class)
    @JsonDeserialize(using=JsonObjectDeserializer.class)
    private transient JsonObject global;
    @JsonSerialize(using=JsonArraySerializer.class)
    @JsonDeserialize(using=JsonArrayDeserializer.class)
    private transient JsonArray source;
    private transient ConcurrentMap<String, JsonObject> mapping;

    public JsonObject getGlobal() {
        return Objects.isNull(this.global) ? new JsonObject() : this.global.copy();
    }

    public void setGlobal(JsonObject global) {
        this.global = global;
    }

    public JsonArray getSource() {
        return this.source;
    }

    public void setSource(JsonArray source) {
        this.source = source;
    }

    public ConcurrentMap<String, JsonObject> getMapping() {
        return this.mapping;
    }

    public void setMapping(ConcurrentMap<String, JsonObject> mapping) {
        this.mapping = mapping;
    }

    public ConcurrentMap<String, String> mapping(String tableName) {
        ConcurrentHashMap<String, String> map = new ConcurrentHashMap<String, String>();
        if (Objects.nonNull(this.mapping)) {
            JsonObject mappingJson = this.mapping.getOrDefault(tableName, new JsonObject());
            Ut.itJObject((JsonObject)mappingJson, (value, field) -> map.put((String)field, (String)value));
        }
        return map;
    }

    public Future<ConcurrentMap<String, JsonObject>> dictionary() {
        ArrayList futures = new ArrayList();
        if (Objects.nonNull(this.source)) {
            Ut.itJArray((JsonArray)this.source, String.class, (expr, index) -> futures.add(this.dictionary((String)expr)));
        }
        return Ux.thenCombineT(futures).compose(result -> {
            ConcurrentHashMap dataResult = new ConcurrentHashMap();
            if (Objects.nonNull(result)) {
                result.stream().filter(Objects::nonNull).forEach(kv -> dataResult.put((String)kv.getKey(), (JsonObject)kv.getValue()));
            }
            return Ux.future(dataResult);
        });
    }

    private Future<Kv<String, JsonObject>> dictionary(String expression) {
        String[] segments = expression.split(",");
        if (5 <= segments.length) {
            String filename = segments[0];
            ExcelClient client = ExcelInfix.createClient();
            return client.ingestAsync(filename).compose(tables -> {
                String table = segments[1];
                HashSet tableSet = new HashSet();
                if (Ut.notNil((String)table)) {
                    tableSet.addAll(tables.stream().filter(Objects::nonNull).filter(each -> table.equals(each.getName())).collect(Collectors.toSet()));
                }
                return Ux.future(tableSet);
            }).compose(tableSet -> {
                String condition = 5 < segments.length ? segments[5] : "";
                String[] kv = condition.split("=");
                Predicate<JsonObject> condFn = 2 == kv.length && Objects.nonNull(kv[0]) ? json -> kv[1].equals(json.getValue(kv[0])) : json -> true;
                ArrayList futures = new ArrayList();
                tableSet.stream().map(Ux::future).map(single -> single.compose(each -> {
                    List<ExRecord> records = each.get();
                    JsonArray data = new JsonArray();
                    records.stream().filter(Objects::nonNull).map(ExRecord::toJson).filter(condFn).forEach(arg_0 -> ((JsonArray)data).add(arg_0));
                    return Ux.future((Object)data);
                })).forEach(futures::add);
                return Ux.thenCombineArray(futures);
            }).compose(dataArray -> {
                String key = segments[4];
                String from = segments[2];
                String to = segments[3];
                JsonObject data = new JsonObject();
                Ut.itJArray((JsonArray)dataArray).forEach(json -> {
                    if (json.containsKey(from) && json.containsKey(to)) {
                        data.put(json.getString(from), json.getValue(to));
                    }
                });
                return Ux.future((Object)Kv.create((Object)key, (Object)data));
            });
        }
        return Ux.future();
    }
}

