/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.excel;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.error._500ExportingErrorException;
import io.vertx.tp.plugin.excel.ExcelClientImpl;
import io.vertx.tp.plugin.excel.ExcelHelper;
import io.vertx.tp.plugin.excel.atom.ExTable;
import io.vertx.up.eon.em.ChangeFlag;
import io.vertx.up.exception.web._500InternalServerException;
import io.vertx.up.log.Annal;
import io.vertx.up.uca.jooq.UxJooq;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;

class SheetImport {
    private static final Annal LOGGER = Annal.get(ExcelClientImpl.class);
    private final transient ExcelHelper helper;

    private SheetImport(ExcelHelper helper) {
        this.helper = helper;
    }

    static SheetImport create(ExcelHelper helper) {
        return new SheetImport(helper);
    }

    <T> Set<T> saveEntity(JsonArray data, ExTable table) {
        HashSet resultSet = new HashSet();
        if (Objects.nonNull(table.classPojo()) && Objects.nonNull(table.classDao())) {
            try {
                String entityKey;
                JsonObject filters = table.whereUnique(data);
                LOGGER.debug("[ \u0388\u03be\u03bf\u03b4\u03bf\u03c2 ]  Table: {1}, Filters: {0}", new Object[]{filters.encode(), table.getName()});
                List entities = Ux.fromJson((JsonArray)data, table.classPojo(), (String)table.filePojo());
                UxJooq jooq = this.jooq(table);
                assert (null != jooq);
                List queried = jooq.fetch(filters);
                ConcurrentMap compared = Ux.compare((List)queried, (List)entities, table.ukIn(), (String)table.filePojo());
                List qUpdate = compared.getOrDefault(ChangeFlag.UPDATE, new ArrayList());
                List qInsert = compared.getOrDefault(ChangeFlag.ADD, new ArrayList());
                if (!qInsert.isEmpty() && Objects.nonNull(entityKey = table.pkIn())) {
                    HashSet keys = new HashSet();
                    qInsert.forEach(item -> {
                        Object value = Ut.field((Object)item, (String)entityKey);
                        if (Objects.nonNull(value)) {
                            keys.add(value.toString());
                        }
                    });
                    List qKeys = jooq.fetchIn(entityKey, keys);
                    if (!qKeys.isEmpty()) {
                        compared = Ux.compare((List)qKeys, (List)qInsert, table.ukIn(), (String)table.filePojo());
                        qUpdate.addAll(compared.getOrDefault(ChangeFlag.UPDATE, new ArrayList()));
                        qInsert.clear();
                        qInsert.addAll(compared.getOrDefault(ChangeFlag.ADD, new ArrayList()));
                    }
                }
                List batchInsert = jooq.insert(this.helper.compress(qInsert, table));
                resultSet.addAll(batchInsert);
                List batchUpdate = jooq.update(qUpdate);
                resultSet.addAll(batchUpdate);
                int total = batchUpdate.size() + batchInsert.size();
                LOGGER.info("[ \u0388\u03be\u03bf\u03b4\u03bf\u03c2 ] `{0}` -- ( {1} ), Inserted: {2}, Updated: {3}", new Object[]{table.getName(), String.valueOf(total), String.valueOf(batchInsert.size()), String.valueOf(batchUpdate.size())});
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                LOGGER.jvm(ex);
            }
        }
        return resultSet;
    }

    <T> T saveEntity(JsonObject data, ExTable table) {
        Object reference = null;
        if (Objects.nonNull(table.classPojo()) && Objects.nonNull(table.classDao())) {
            Object fetched;
            String key;
            JsonObject filters = table.whereUnique(data);
            LOGGER.debug("[ \u0388\u03be\u03bf\u03b4\u03bf\u03c2 ]  Table: {1}, Filters: {0}", new Object[]{filters.encode(), table.getName()});
            Object entity = Ux.fromJson((JsonObject)data, table.classPojo(), (String)table.filePojo());
            UxJooq jooq = this.jooq(table);
            assert (null != jooq);
            Object queried = jooq.fetchOne(filters);
            reference = null == queried ? (Ut.isNil((String)(key = (String)table.whereKey(data))) ? jooq.insert(entity) : (null == (fetched = jooq.fetchById((Object)key)) ? jooq.insert(entity) : jooq.update(entity))) : jooq.update(entity);
        }
        return (T)reference;
    }

    <T> Future<Set<T>> importAsync(Set<ExTable> tables) {
        ArrayList futures = new ArrayList();
        tables.forEach(table -> futures.add(this.helper.extract((ExTable)table).compose(data -> Ux.future(this.saveEntity((JsonArray)data, (ExTable)table)))));
        return Ux.thenCombineT(futures).compose(result -> {
            HashSet entitySet = new HashSet();
            result.forEach(entitySet::addAll);
            return Ux.future(entitySet);
        });
    }

    <T> Future<Set<T>> importAsync(AsyncResult<Set<ExTable>> async) {
        if (async.succeeded()) {
            Set tables = (Set)async.result();
            return this.importAsync(tables);
        }
        Throwable error = async.cause();
        if (Objects.nonNull(error)) {
            return Future.failedFuture((Throwable)((Object)new _500ExportingErrorException(this.getClass(), error.getMessage())));
        }
        return Future.failedFuture((Throwable)new _500InternalServerException(this.getClass(), "Unexpected Error when Importing"));
    }

    private UxJooq jooq(ExTable table) {
        String pojoFile;
        UxJooq jooq = Ux.Jooq.on(table.classDao());
        if (null != jooq && Ut.notNil((String)(pojoFile = table.filePojo()))) {
            jooq.on(pojoFile);
        }
        return jooq;
    }
}

