/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.excel;

import io.vertx.core.Future;
import io.vertx.tp.plugin.excel.ExcelHelper;
import io.vertx.tp.plugin.excel.atom.ExTable;
import io.vertx.up.commune.element.TypeAtom;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.Workbook;

class SheetIngest {
    private final transient ExcelHelper helper;

    private SheetIngest(ExcelHelper helper) {
        this.helper = helper;
    }

    static SheetIngest create(ExcelHelper helper) {
        return new SheetIngest(helper);
    }

    Set<ExTable> ingest(InputStream in, boolean isXlsx) {
        return this.ingest(in, isXlsx, TypeAtom.create());
    }

    Set<ExTable> ingest(String filename) {
        return this.ingest(filename, TypeAtom.create());
    }

    Set<ExTable> ingest(InputStream in, boolean isXlsx, TypeAtom typeAtom) {
        Workbook workbook = this.helper.getWorkbook(in, isXlsx);
        return this.helper.getExTables(workbook, typeAtom);
    }

    Set<ExTable> ingest(String filename, TypeAtom typeAtom) {
        Workbook workbook = this.helper.getWorkbook(filename);
        return this.helper.getExTables(workbook, typeAtom);
    }

    private Set<ExTable> compress(Set<ExTable> processed, String ... includes) {
        HashSet<String> tables = new HashSet<String>(Arrays.asList(includes));
        return processed.stream().filter(table -> tables.contains(table.getName())).collect(Collectors.toSet());
    }

    Future<Set<ExTable>> compressAsync(Set<ExTable> processed, String ... includes) {
        return Future.succeededFuture(this.compress(processed, includes));
    }
}

