/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.excel.atom;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.error._404ConnectMissingException;
import io.vertx.tp.plugin.booting.KConnect;
import io.vertx.tp.plugin.excel.atom.ExRecord;
import io.vertx.up.fn.Fn;
import io.vertx.up.util.Ut;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ExTable
implements Serializable {
    private final transient List<String> fields = new ArrayList<String>();
    private final transient List<ExRecord> values = new ArrayList<ExRecord>();
    private final transient String sheet;
    private final transient ConcurrentMap<Integer, String> indexMap = new ConcurrentHashMap<Integer, String>();
    private transient String name;
    private transient String description;
    private transient KConnect connect;

    public ExTable(String sheet) {
        this.sheet = sheet;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public <T> Class<T> classPojo() {
        return this.getConnect().getPojo();
    }

    public Class<?> classDao() {
        return this.getConnect().getDao();
    }

    public String filePojo() {
        return this.getConnect().getPojoFile();
    }

    public Set<String> ukIn() {
        return this.getConnect().ukIn();
    }

    public String pkIn() {
        return this.getConnect().pkIn();
    }

    public JsonObject whereUnique(JsonObject data) {
        JsonArray unique = this.getConnect().getUnique();
        JsonObject filters = new JsonObject();
        Ut.itJArray((JsonArray)unique, String.class, (field, index) -> {
            Object value = data.getValue(field);
            if (Objects.nonNull(value)) {
                filters.put(field, value);
            }
        });
        return filters;
    }

    public JsonObject whereUnique(JsonArray data) {
        JsonObject filters = new JsonObject();
        filters.put("", (Object)Boolean.FALSE);
        Ut.itJArray((JsonArray)data, JsonObject.class, (item, index) -> {
            String indexKey = "$" + index;
            filters.put(indexKey, (Object)this.whereUnique((JsonObject)item).put("", (Object)Boolean.TRUE));
        });
        return filters;
    }

    public <ID> ID whereKey(JsonObject data) {
        String keyField = this.pkIn();
        if (Objects.nonNull(keyField)) {
            Object id = data.getValue(keyField);
            return (ID)(null == id ? null : id);
        }
        return null;
    }

    public void add(String field) {
        if (Ut.notNil((String)field)) {
            int index = this.indexMap.size();
            this.fields.add(field);
            this.indexMap.put(index, field);
        }
    }

    public void add(String field, String child) {
        if (Ut.notNil((String)field) && Ut.notNil((String)child)) {
            String combine = field + "." + child;
            if (!this.fields.contains(combine)) {
                this.fields.add(combine);
            }
            int index = this.indexMap.size();
            this.indexMap.put(index, combine);
        }
    }

    public void add(ExRecord record) {
        if (!record.isEmpty()) {
            this.values.add(record);
        }
    }

    public Set<Integer> indexDiff() {
        HashSet<Integer> excludes = new HashSet<Integer>();
        this.indexMap.forEach((index, field) -> {
            if (!field.contains(".")) {
                excludes.add((Integer)index);
            }
        });
        return excludes;
    }

    public List<ExRecord> get() {
        return this.values;
    }

    public String field(int index) {
        return this.indexMap.getOrDefault(index, null);
    }

    public int size() {
        return this.fields.size();
    }

    private KConnect getConnect() {
        Fn.outWeb((null == this.connect ? 1 : 0) != 0, _404ConnectMissingException.class, (Object[])new Object[]{this.getClass(), this.name});
        return this.connect;
    }

    public void setConnect(KConnect connect) {
        this.connect = connect;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExTable)) {
            return false;
        }
        ExTable table = (ExTable)o;
        return this.name.equals(table.name) && this.sheet.equals(table.sheet);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.sheet);
    }

    public String toString() {
        StringBuilder content = new StringBuilder();
        content.append("sheet = ").append(this.sheet).append(",");
        content.append("name = ").append(this.name).append(",");
        content.append("description = ").append(this.description).append("\n");
        content.append("daoCls = ").append(this.connect).append(",\n");
        this.fields.forEach(field -> content.append((String)field).append(","));
        content.append("\n");
        this.values.forEach(row -> content.append(row.toString()).append("\n"));
        return content.toString();
    }
}

