/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.excel.atom;

import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.plugin.excel.ExcelClient;
import io.vertx.tp.plugin.excel.ExcelInfix;
import io.vertx.tp.plugin.excel.atom.ExRecord;
import io.vertx.up.atom.Kv;
import io.vertx.up.atom.unity.UTenant;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ExTenant
implements Serializable {
    private final transient UTenant tenant;

    private ExTenant(JsonObject tenantData) {
        this.tenant = (UTenant)Ut.deserialize((JsonObject)tenantData, UTenant.class);
    }

    public static ExTenant create(JsonObject tenantData) {
        return new ExTenant(tenantData);
    }

    public JsonObject valueDefault() {
        return this.tenant.getGlobal();
    }

    public Kv<String, Set<String>> valueCriteria(String tableName) {
        JsonObject criteria = this.tenant.getForbidden().getOrDefault(tableName, new JsonObject());
        if (Ut.notNil((JsonObject)criteria)) {
            String field = (String)criteria.fieldNames().iterator().next();
            JsonArray values = criteria.getJsonArray(field, new JsonArray());
            return Kv.create((Object)field, (Object)Ut.toSet((JsonArray)values));
        }
        return Kv.create();
    }

    public ConcurrentMap<String, String> dictionaryDefinition(String tableName) {
        ConcurrentHashMap<String, String> map = new ConcurrentHashMap<String, String>();
        if (Objects.nonNull(this.tenant.getMapping())) {
            JsonObject mappingJson = this.tenant.getMapping().getOrDefault(tableName, new JsonObject());
            Ut.itJObject((JsonObject)mappingJson, (value, field) -> map.put((String)field, (String)value));
        }
        return map;
    }

    public ConcurrentMap<String, ConcurrentMap<String, String>> tree(String tableName) {
        ConcurrentHashMap<String, ConcurrentMap<String, String>> map = new ConcurrentHashMap<String, ConcurrentMap<String, String>>();
        if (Objects.nonNull(this.tenant.getDictionary())) {
            JsonObject tableData = this.tenant.getDictionary().getOrDefault(tableName, new JsonObject());
            Ut.itJObject((JsonObject)tableData, (data, field) -> {
                ConcurrentHashMap combine = new ConcurrentHashMap();
                Ut.itJObject((JsonObject)data, (key, fieldValue) -> combine.put(fieldValue, key));
                map.put((String)field, combine);
            });
        }
        return map;
    }

    public Future<ConcurrentMap<String, JsonObject>> dictionary() {
        ArrayList futures = new ArrayList();
        if (Objects.nonNull(this.tenant.getSource())) {
            Ut.itJArray((JsonArray)this.tenant.getSource(), String.class, (expr, index) -> futures.add(this.dictionary((String)expr)));
        }
        return Ux.thenCombineT(futures).compose(result -> {
            ConcurrentHashMap dataResult = new ConcurrentHashMap();
            if (Objects.nonNull(result)) {
                result.stream().filter(Objects::nonNull).forEach(kv -> dataResult.put((String)kv.getKey(), (JsonObject)kv.getValue()));
            }
            return Ux.future(dataResult);
        });
    }

    private Future<Kv<String, JsonObject>> dictionary(String expression) {
        String[] segments = expression.split(",");
        if (5 <= segments.length) {
            String filename = segments[0];
            ExcelClient client = ExcelInfix.createClient();
            return client.ingestAsync(filename).compose(tables -> {
                String table = segments[1];
                HashSet tableSet = new HashSet();
                if (Ut.notNil((String)table)) {
                    tableSet.addAll(tables.stream().filter(Objects::nonNull).filter(each -> table.equals(each.getName())).collect(Collectors.toSet()));
                }
                return Ux.future(tableSet);
            }).compose(tableSet -> {
                String condition = 5 < segments.length ? segments[5] : "";
                String[] kv = condition.split("=");
                Predicate<JsonObject> condFn = 2 == kv.length && Objects.nonNull(kv[0]) ? json -> kv[1].equals(json.getValue(kv[0])) : json -> true;
                ArrayList futures = new ArrayList();
                tableSet.stream().map(Ux::future).map(single -> single.compose(each -> {
                    List<ExRecord> records = each.get();
                    JsonArray data = new JsonArray();
                    records.stream().filter(Objects::nonNull).map(ExRecord::toJson).filter(condFn).forEach(arg_0 -> ((JsonArray)data).add(arg_0));
                    return Ux.future((Object)data);
                })).forEach(futures::add);
                return Ux.thenCombineArray(futures);
            }).compose(dataArray -> {
                String key = segments[4];
                String from = segments[2];
                String to = segments[3];
                JsonObject data = new JsonObject();
                Ut.itJArray((JsonArray)dataArray).forEach(json -> {
                    if (json.containsKey(from) && json.containsKey(to)) {
                        data.put(json.getString(from), json.getValue(to));
                    }
                });
                return Ux.future((Object)Kv.create((Object)key, (Object)data));
            });
        }
        return Ux.future();
    }
}

