/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.excel;

import com.fasterxml.jackson.core.type.TypeReference;
import io.horizon.uca.cache.Cc;
import io.horizon.uca.log.Annal;
import io.modello.atom.typed.MetaAtom;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.error._404ExcelFileNullException;
import io.vertx.tp.plugin.booting.KBoot;
import io.vertx.tp.plugin.booting.KConnect;
import io.vertx.tp.plugin.excel.ExTpl;
import io.vertx.tp.plugin.excel.Pool;
import io.vertx.tp.plugin.excel.SheetAnalyzer;
import io.vertx.tp.plugin.excel.atom.ExRecord;
import io.vertx.tp.plugin.excel.atom.ExTable;
import io.vertx.tp.plugin.excel.atom.ExTenant;
import io.vertx.tp.plugin.excel.ranger.RowBound;
import io.vertx.up.fn.Fn;
import io.vertx.up.unity.Ux;
import io.vertx.up.util.Ut;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

class ExcelHelper {
    private static final Cc<String, ExcelHelper> CC_HELPER = Cc.open();
    private static final Cc<String, Workbook> CC_WORKBOOK = Cc.open();
    private static final Cc<Integer, Workbook> CC_WORKBOOK_STREAM = Cc.open();
    private static final Map<String, Workbook> REFERENCES = new ConcurrentHashMap<String, Workbook>();
    private final transient Class<?> target;
    ConcurrentMap<String, KConnect> CONNECTS = new ConcurrentHashMap<String, KConnect>();
    private transient ExTpl tpl;
    private transient ExTenant tenant;

    private ExcelHelper(Class<?> target) {
        this.target = target;
    }

    static ExcelHelper helper(Class<?> target) {
        return (ExcelHelper)CC_HELPER.pick(() -> new ExcelHelper(target), (Object)target.getName());
    }

    Future<JsonArray> extract(Set<ExTable> tables) {
        ArrayList futures = new ArrayList();
        tables.forEach(table -> futures.add(this.extract((ExTable)table)));
        return Fn.compressA(futures);
    }

    private Future<JsonArray> extractDynamic(JsonArray dataArray, String name) {
        JsonArray normalized;
        if (Objects.isNull(this.tenant)) {
            return Ux.future((Object)dataArray);
        }
        JsonObject valueDefault = this.tenant.valueDefault();
        if (Ut.isNotNil((JsonObject)valueDefault)) {
            normalized = new JsonArray();
            Ut.itJArray((JsonArray)dataArray).forEach(json -> normalized.add((Object)valueDefault.copy().mergeIn(json, true)));
        } else {
            normalized = dataArray.copy();
        }
        ConcurrentMap<String, String> first = this.tenant.dictionaryDefinition(name);
        if (first.isEmpty()) {
            return Ux.future((Object)normalized);
        }
        return this.tenant.dictionary().compose(dataMap -> {
            if (!dataMap.isEmpty()) {
                ConcurrentMap combine = Ut.elementZip((ConcurrentMap)first, (ConcurrentMap)dataMap);
                combine.forEach((key, value) -> Ut.itJArray((JsonArray)normalized).forEach(json -> {
                    String fromValue = json.getString(key);
                    if (Ut.isNotNil((String)fromValue) && value.containsKey(fromValue)) {
                        Object toValue = value.getValue(fromValue);
                        json.put(key, toValue);
                    }
                }));
            }
            return Ux.future((Object)normalized);
        });
    }

    private JsonArray extractStatic(JsonArray dataArray, String name) {
        ConcurrentMap<String, ConcurrentMap<String, String>> tree = this.tenant.tree(name);
        if (!tree.isEmpty()) {
            tree.forEach((field, map) -> Ut.itJArray((JsonArray)dataArray).forEach(record -> {
                String input = record.getString(field);
                if (map.containsKey(input)) {
                    String output = (String)map.get(input);
                    record.put(field, (Object)output);
                }
            }));
        }
        return dataArray;
    }

    private Future<JsonArray> extractForbidden(JsonArray dataArray, String name) {
        ConcurrentMap<String, Set<String>> forbidden = this.tenant.valueCriteria(name);
        if (forbidden.isEmpty()) {
            return Ux.future((Object)dataArray);
        }
        JsonArray normalized = new JsonArray();
        Ut.itJArray((JsonArray)dataArray).filter(item -> forbidden.keySet().stream().allMatch(field -> {
            if (item.containsKey(field)) {
                String value;
                Set values = (Set)forbidden.get(field);
                return !values.contains(value = item.getString(field));
            }
            return true;
        })).forEach(arg_0 -> ((JsonArray)normalized).add(arg_0));
        return Ux.future((Object)normalized);
    }

    Future<JsonArray> extract(ExTable table) {
        List<ExRecord> records = table.get();
        String tableName = table.getName();
        JsonArray dataArray = new JsonArray();
        records.stream().filter(Objects::nonNull).map(ExRecord::toJson).forEach(arg_0 -> ((JsonArray)dataArray).add(arg_0));
        return Ux.future((Object)this.extractStatic(dataArray, tableName)).compose(extracted -> this.extractDynamic((JsonArray)extracted, tableName)).compose(extracted -> this.extractForbidden((JsonArray)extracted, tableName));
    }

    private void extractIngest(Set<ExTable> dataSet) {
        JsonObject dataGlobal;
        if (Objects.nonNull(this.tenant) && Ut.isNotNil((JsonObject)(dataGlobal = this.tenant.valueDefault()))) {
            JsonObject developer = Ut.valueJObject((JsonObject)dataGlobal, (String)"developer").copy();
            JsonObject normalized = dataGlobal.copy();
            normalized.remove("developer");
            dataSet.forEach(table -> {
                if ("S_USER".equals(table.getName()) && Ut.isNotNil((JsonObject)developer)) {
                    table.get().forEach(record -> {
                        record.putOr(normalized);
                        String username = (String)record.get("username");
                        if (developer.containsKey(username)) {
                            record.put("modelKey", developer.getString(username));
                        }
                    });
                } else {
                    table.get().forEach(record -> record.putOr(normalized));
                }
            });
        }
    }

    Workbook getWorkbook(String filename) {
        Fn.outWeb((null == filename ? 1 : 0) != 0, _404ExcelFileNullException.class, (Object[])new Object[]{this.target, filename});
        InputStream in = Ut.ioStream((String)filename, this.getClass());
        Fn.outWeb((null == in ? 1 : 0) != 0, _404ExcelFileNullException.class, (Object[])new Object[]{this.target, filename});
        Workbook workbook = filename.endsWith("xls") ? (Workbook)CC_WORKBOOK.pick(() -> (Workbook)Fn.failOr(() -> new HSSFWorkbook(in)), (Object)filename) : (Workbook)CC_WORKBOOK.pick(() -> (Workbook)Fn.failOr(() -> new XSSFWorkbook(in)), (Object)filename);
        return workbook;
    }

    Workbook getWorkbook(InputStream in, boolean isXlsx) {
        Fn.outWeb((null == in ? 1 : 0) != 0, _404ExcelFileNullException.class, (Object[])new Object[]{this.target, "Stream"});
        Workbook workbook = isXlsx ? (Workbook)CC_WORKBOOK_STREAM.pick(() -> (Workbook)Fn.failOr(() -> new XSSFWorkbook(in)), (Object)in.hashCode()) : (Workbook)CC_WORKBOOK_STREAM.pick(() -> (Workbook)Fn.failOr(() -> new HSSFWorkbook(in)), (Object)in.hashCode());
        workbook.setForceFormulaRecalculation(Boolean.TRUE.booleanValue());
        return workbook;
    }

    Set<ExTable> getExTables(Workbook workbook, MetaAtom metaAtom) {
        return (Set)Fn.runOr(new HashSet(), () -> {
            FormulaEvaluator evaluator = workbook.getCreationHelper().createFormulaEvaluator();
            ConcurrentHashMap<String, FormulaEvaluator> references = new ConcurrentHashMap<String, FormulaEvaluator>();
            REFERENCES.forEach((field, workbookRef) -> {
                FormulaEvaluator executorRef = workbookRef.getCreationHelper().createFormulaEvaluator();
                references.put((String)field, executorRef);
            });
            references.put(workbook.createName().getNameName(), evaluator);
            evaluator.setupReferencedWorkbooks(references);
            Iterator it = workbook.sheetIterator();
            HashSet<ExTable> sheets = new HashSet<ExTable>();
            while (it.hasNext()) {
                Sheet sheet = (Sheet)it.next();
                RowBound range = new RowBound(sheet);
                SheetAnalyzer exSheet = new SheetAnalyzer(sheet).on(evaluator);
                Set<ExTable> dataSet = exSheet.analyzed(range, metaAtom);
                this.extractIngest(dataSet);
                sheets.addAll(dataSet);
            }
            return sheets;
        }, (Object[])new Object[]{workbook});
    }

    void brush(Workbook workbook, Sheet sheet, MetaAtom metaAtom) {
        if (Objects.nonNull(this.tpl)) {
            this.tpl.bind(workbook);
            this.tpl.applyStyle(sheet, metaAtom);
        }
    }

    void initPen(String componentStr) {
        Class tplCls;
        if (Ut.isNotNil((String)componentStr) && Ut.isImplement((Class)(tplCls = Ut.clazz((String)componentStr, null)), ExTpl.class)) {
            this.tpl = (ExTpl)Ut.singleton((String)componentStr, (Object[])new Object[0]);
        }
    }

    void initConnect(JsonArray connects) {
        if (Pool.CONNECTS.isEmpty()) {
            List connectList = Ut.deserialize((JsonArray)connects, (TypeReference)new TypeReference<List<KConnect>>(){});
            connectList.stream().filter(Objects::nonNull).filter(connect -> Objects.nonNull(connect.getTable())).forEach(connect -> Pool.CONNECTS.put(connect.getTable(), (KConnect)connect));
            Set boots = KBoot.initialize();
            boots.forEach(boot -> Pool.CONNECTS.putAll(boot.configure()));
        }
    }

    void initEnvironment(JsonArray environments) {
        environments.stream().filter(Objects::nonNull).map(item -> (JsonObject)item).forEach(each -> {
            String path = each.getString("path");
            String name = each.getString("name");
            Workbook workbook = this.getWorkbook(path);
            REFERENCES.put(name, workbook);
            this.initEnvironment((JsonObject)each, workbook);
        });
    }

    void initTenant(ExTenant tenant) {
        this.tenant = tenant;
    }

    private void initEnvironment(JsonObject each, Workbook workbook) {
        if (each.containsKey("alias")) {
            JsonArray alias = each.getJsonArray("alias");
            File current = new File("");
            Ut.itJArray((JsonArray)alias, String.class, (item, index) -> {
                String filename = current.getAbsolutePath() + item;
                File file = new File(filename);
                if (file.exists()) {
                    REFERENCES.put(file.getAbsolutePath(), workbook);
                }
            });
        }
    }

    <T> List<T> compress(List<T> input, ExTable table) {
        String key = table.pkIn();
        if (Objects.isNull(key)) {
            return input;
        }
        ArrayList keyList = new ArrayList();
        HashSet keys = new HashSet();
        AtomicInteger counter = new AtomicInteger(0);
        input.forEach(item -> {
            Object value = Ut.field((Object)item, (String)key);
            if (Objects.nonNull(value) && !keys.contains(value)) {
                keys.add(value);
                keyList.add(item);
            } else {
                counter.incrementAndGet();
            }
        });
        int ignored = counter.get();
        if (0 < ignored) {
            Annal annal = Annal.get(this.target);
            annal.warn("[ \u0388\u03be\u03bf\u03b4\u03bf\u03c2 ] Ignore table `{0}` with size `{1}`", new Object[]{table.getName(), ignored});
        }
        return keyList;
    }
}

