/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.tp.plugin.excel;

import io.horizon.uca.log.Annal;
import io.modello.atom.typed.MetaAtom;
import io.vertx.tp.plugin.booting.KConnect;
import io.vertx.tp.plugin.excel.Pool;
import io.vertx.tp.plugin.excel.atom.ExTable;
import io.vertx.tp.plugin.excel.ranger.ColBound;
import io.vertx.tp.plugin.excel.ranger.ComplexIn;
import io.vertx.tp.plugin.excel.ranger.ExBound;
import io.vertx.tp.plugin.excel.ranger.ExIn;
import io.vertx.tp.plugin.excel.ranger.PureIn;
import io.vertx.tp.plugin.excel.tool.ExFn;
import io.vertx.up.uca.log.DevEnv;
import io.vertx.up.util.Ut;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public class SheetAnalyzer
implements Serializable {
    private static final Annal LOGGER = Annal.get(SheetAnalyzer.class);
    private final transient Sheet sheet;
    private transient FormulaEvaluator evaluator;
    private transient ExIn scanner;

    public SheetAnalyzer(Sheet sheet) {
        this.sheet = sheet;
    }

    public SheetAnalyzer on(FormulaEvaluator evaluator) {
        this.evaluator = evaluator;
        return this;
    }

    public Set<ExTable> analyzed(ExBound bound, MetaAtom metaAtom) {
        if (DevEnv.devExcelRange()) {
            LOGGER.info("[ \u0388\u03be\u03bf\u03b4\u03bf\u03c2 ] Scan Range: {0}", new Object[]{bound});
        }
        try {
            HashSet<ExTable> tables = new HashSet<ExTable>();
            ArrayList<Cell> tableCell = new ArrayList<Cell>();
            ExFn.itSheet(this.sheet, bound, (row, index) -> {
                ColBound colBound = new ColBound((Row)row);
                ExFn.itRow(row, colBound, (cell, colIndex) -> tableCell.add((Cell)cell), cell -> CellType.STRING == cell.getCellType() && Ut.isNotNil((String)cell.getStringCellValue()) && cell.getStringCellValue().equals("{TABLE}"));
            });
            if (!tableCell.isEmpty()) {
                if (DevEnv.devExcelRange()) {
                    LOGGER.info("[ \u0388\u03be\u03bf\u03b4\u03bf\u03c2 ] Scanned sheet: {0}, tableCell = {1}", new Object[]{this.sheet.getSheetName(), String.valueOf(tableCell.size())});
                }
                ConcurrentMap<Integer, Integer> range = this.getRange(tableCell);
                tableCell.stream().map(cell -> {
                    Row row = this.sheet.getRow(cell.getRowIndex());
                    if (null == row) {
                        return null;
                    }
                    Integer limit = (Integer)range.get(cell.hashCode());
                    return this.analyzed(row, (Cell)cell, limit, metaAtom);
                }).filter(Objects::nonNull).forEach(tables::add);
            }
            return tables;
        }
        catch (Throwable ex) {
            LOGGER.fatal(ex);
            return new HashSet<ExTable>();
        }
    }

    private ConcurrentMap<Integer, Integer> getRange(List<Cell> tableCell) {
        ArrayList hashCodes = new ArrayList();
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        tableCell.forEach(cell -> {
            indexes.add(cell.getRowIndex() - 1);
            hashCodes.add(cell.hashCode());
        });
        indexes.add(this.sheet.getLastRowNum());
        indexes.remove(0);
        ConcurrentHashMap<Integer, Integer> indexMap = new ConcurrentHashMap<Integer, Integer>();
        for (int idx = 0; idx < hashCodes.size(); ++idx) {
            Integer key = (Integer)hashCodes.get(idx);
            Integer index = (Integer)indexes.get(idx);
            indexMap.put(key, index);
        }
        return indexMap;
    }

    private ExTable analyzed(Row row, Cell cell, Integer limitation, MetaAtom metaAtom) {
        ExTable table = this.create(row, cell);
        ExIn in = Objects.nonNull(metaAtom) && metaAtom.isComplex() ? new ComplexIn(this.sheet).bind(this.evaluator) : new PureIn(this.sheet).bind(this.evaluator);
        ExBound dataRange = in.applyTable(table, row, cell, limitation);
        return in.applyData(table, dataRange, cell, metaAtom);
    }

    private ExTable create(Row row, Cell cell) {
        KConnect connect;
        ExTable table = new ExTable(this.sheet.getSheetName());
        ExFn.onCell(row, cell.getColumnIndex() + 1, found -> table.setName(found.getStringCellValue()));
        ExFn.onCell(row, cell.getColumnIndex() + 2, found -> table.setDescription(found.getStringCellValue()));
        if (Objects.nonNull(table.getName()) && Pool.CONNECTS.containsKey(table.getName()) && Objects.nonNull(connect = (KConnect)Pool.CONNECTS.get(table.getName()))) {
            table.setConnect(connect);
        }
        return table;
    }
}

